/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.scheduler;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.core.impl.MemoryRunDetailsDao;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.core.spi.SchedulerServiceConfiguration;
import com.atlassian.scheduler.quartz1.Quartz1SchedulerService;
import com.atlassian.tenancy.api.TenantAccessor;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.config.RootConfig;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="schedulerService")
@AvailableToPlugins(value=SchedulerService.class)
public class FeCruSchedulerService
extends Quartz1SchedulerService {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public FeCruSchedulerService(@Qualifier(value="schedulerServiceQuartzScheduler") Scheduler quartzScheduler, RootConfig rootConfig, TenantAccessor tenantAccessor, CurrentSessionProvider currentSessionProvider) throws SchedulerServiceException {
        super((RunDetailsDao)new MemoryRunDetailsDao(), FeCruSchedulerService.createSchedulerServiceConfiguration(rootConfig), quartzScheduler, quartzScheduler, tenantAccessor);
        this.currentSessionProvider = currentSessionProvider;
    }

    @Nonnull
    private static SchedulerServiceConfiguration createSchedulerServiceConfiguration(final RootConfig rootConfig) {
        return new SchedulerServiceConfiguration(){

            @Nullable
            public TimeZone getDefaultTimeZone() {
                return rootConfig.getTimezone();
            }
        };
    }

    public void registerJobRunner(JobRunnerKey jobRunnerKey, JobRunner jobRunner) {
        super.registerJobRunner(jobRunnerKey, (JobRunner)new SessionTerminatingJobRunner(jobRunner));
    }

    private class SessionTerminatingJobRunner
    implements JobRunner {
        private final JobRunner jobRunner;

        public SessionTerminatingJobRunner(JobRunner jobRunner) {
            this.jobRunner = jobRunner;
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            try {
                JobRunnerResponse jobRunnerResponse = this.jobRunner.runJob(request);
                return jobRunnerResponse;
            }
            finally {
                FeCruSchedulerService.this.currentSessionProvider.currentSession().close();
            }
        }
    }
}

