/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.sal.pluginsettings.appconfig;

import com.atlassian.crucible.actions.admin.project.data.ProjectData;
import com.atlassian.crucible.actions.admin.project.data.ProjectDataFactory;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.crucible.configuration.metrics.XMLValidationException;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.sal.pluginsettings.appconfig.FisheyeAccessor;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LinkerSimpleType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.util.XmlbeansUtil;
import com.cenqua.fisheye.web.admin.actions.svn.SvnSymbolicHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component(value="fisheyeAccessor")
@AvailableToPlugins
public class DefaultFisheyeAccessor
implements FisheyeAccessor {
    private static final int REPO_CHILD_INDENT = 6;
    private static final int REPO_INDENT = 2;
    private final ProjectManager projectManager;
    private final ProjectDataFactory projectDataFactory;
    private final TxTemplate txTemplate;
    private final LicenseManager licenseManager;
    private final AdminUserConfig adminUserConfig;

    @Autowired
    public DefaultFisheyeAccessor(ProjectManager projectManager, ProjectDataFactory projectDataFactory, TxTemplate txTemplate, LicenseManager licenseManager, AdminUserConfig adminUserConfig) {
        this.projectManager = projectManager;
        this.projectDataFactory = projectDataFactory;
        this.txTemplate = txTemplate;
        this.licenseManager = licenseManager;
        this.adminUserConfig = adminUserConfig;
    }

    @Override
    public boolean repositoryExists(String repName) {
        RootConfig rootConfig = AppConfig.getsConfig();
        RepositoryHandle handle = rootConfig.getRepositoryManager().getRepository(repName);
        return handle != null;
    }

    @Override
    public String getSiteURL() {
        return AppConfig.getsConfig().getSiteURL();
    }

    @Override
    public TimeZone getDefaultTimeZone() {
        return AppConfig.getsConfig().getTimezone();
    }

    @Override
    public TimeZone getUserTimeZone(String username) {
        return AppConfig.getUserTimeZone(username);
    }

    @Override
    public File getInstanceDirectory() {
        return AppConfig.getInstanceDir();
    }

    @Override
    public void createRepository(String repName, String description, String svnUrl, String svnUsername, String svnPassword, List<FisheyeAccessor.Linker> linkers) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            SvnSymbolicHelper svnSymbolic = new SvnSymbolicHelper();
            svnSymbolic.setupType1();
            SvnRepType svn = SvnRepType.Factory.newInstance();
            svn.setUrl(svnUrl);
            svn.setPath(repName);
            svn.setSymbolic(svnSymbolic.toXmlBean());
            svn.addNewAuth();
            svn.getAuth().setUsername(svnUsername);
            svn.getAuth().setPassword(svnPassword);
            svn.setCharset("UTF-8");
            RepositoryType repository = RepositoryType.Factory.newInstance();
            repository.setName(repName);
            int rep = AppConfig.getsConfig().addRepositoryType(repository);
            repository = AppConfig.getsConfig().getRepositoryType(rep);
            repository.setDescription(description);
            repository.setSvn(svn);
            repository.setEnabled(true);
            XmlbeansUtil.placeOnNewLine(repository.getSvn(), 6);
            XmlbeansUtil.placeOnNewLine(repository, 2);
            LinkerType linkerType = LinkerType.Factory.newInstance();
            for (FisheyeAccessor.Linker linker : linkers) {
                LinkerSimpleType simpleLinkerConfig = linkerType.addNewSimple();
                simpleLinkerConfig.setRegex(linker.getRegexp());
                simpleLinkerConfig.setHref(linker.getHref());
                simpleLinkerConfig.setDescription(linker.getDescription());
            }
            repository.setLinker(linkerType);
            AppConfig.getsConfig().saveConfig();
            RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
            rm.reloadList();
            rm.runRepository(repName);
        }
        catch (Exception e2) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error creating fisheye repository: " + e2.getMessage(), e2);
        }
    }

    @Override
    public void deleteRepository(String repName) throws FisheyeAccessor.FisheyeAccessorException {
        AppConfig.getsConfig().getRepositoryManager().getRepository(repName).stop();
        int id = this.getRepositoryId(repName);
        try {
            AppConfig.getsConfig().getConfig().removeRepository(id);
            AppConfig.getsConfig().saveConfig();
            AppConfig.getsConfig().getRepositoryManager().reloadList();
        }
        catch (IndexOutOfBoundsException e2) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error retrieving repository '" + repName + "' for id '" + id + "'. Unable to delete.", e2);
        }
        catch (IOException e3) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error saving fisheye config when deleting repository '" + repName + "'.");
        }
        catch (ConfigException e4) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error reloading fisheye config when deleting repository '" + repName + "'.");
        }
    }

    @Override
    public void setRepositoryLinkers(String repositoryName, List<FisheyeAccessor.Linker> linkers) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            RepositoryType repositoryType = this.getRepositoryType(repositoryName);
            if (repositoryType == null) {
                throw new FisheyeAccessor.FisheyeAccessorException("Error setting up repository linkers. Repository " + repositoryName + " not found");
            }
            LinkerType linkerType = LinkerType.Factory.newInstance();
            for (FisheyeAccessor.Linker linker : linkers) {
                LinkerSimpleType simpleLinkerConfig = linkerType.addNewSimple();
                simpleLinkerConfig.setRegex(linker.getRegexp());
                simpleLinkerConfig.setHref(linker.getHref());
                simpleLinkerConfig.setDescription(linker.getDescription());
            }
            repositoryType.setLinker(linkerType);
            RepositoryHandle repositoryHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(repositoryName);
            repositoryHandle.getCfg().setupLinker();
            AppConfig.getsConfig().saveConfig();
            RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
            rm.reloadList();
        }
        catch (ConfigException | IOException e2) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error setting up repository linkers: " + e2, e2);
        }
    }

    private int getRepositoryId(String repositoryName) {
        RepositoryType[] repositoryArray = AppConfig.getsConfig().getConfig().getRepositoryArray();
        for (int i2 = 0; i2 < repositoryArray.length; ++i2) {
            RepositoryType repositoryType = repositoryArray[i2];
            if (!repositoryName.equals(repositoryType.getName())) continue;
            return i2;
        }
        return -1;
    }

    private RepositoryType getRepositoryType(String repositoryName) {
        RepositoryType[] repositories;
        for (RepositoryType repository : repositories = AppConfig.getsConfig().getConfigDocument().getConfig().getRepositoryArray()) {
            if (!repository.getName().equals(repositoryName)) continue;
            return repository;
        }
        return null;
    }

    @Override
    public void enableAnonymousAccess(boolean enable) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            RepSecurityType security = cfg.getRepositoryDefaults().getSecurity();
            security.setAllowAnon(enable);
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error " + (enable ? "enabling" : "disabling") + " anonymous access to fisheye repositories. " + e2, e2);
        }
    }

    @Override
    public void setLicense(String license) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            this.licenseManager.updateLicenses(license, license);
        }
        catch (IOException ioe) {
            throw new FisheyeAccessor.FisheyeAccessorException("Error saving configuration while reloading license", ioe);
        }
    }

    @Override
    public LicenseInfo getLicenseInfo() {
        return this.licenseManager.getLicenseInfo();
    }

    @Override
    public boolean isApplicationSetUp() {
        return true;
    }

    @Override
    public Collection<String> getRepositoryNames() {
        ArrayList<String> results = new ArrayList<String>();
        List<RepositoryHandle> handles = AppConfig.getsConfig().getRepositoryManager().getHandles();
        for (RepositoryHandle handle : handles) {
            results.add(handle.getName());
        }
        return results;
    }

    @Override
    public void updateProject(final ProjectData projectData) {
        this.txTemplate.execute(new TxCallback<Object>(){

            @Override
            public Object doInTransaction(TransactionStatus transactionStatus) throws Exception {
                DefaultFisheyeAccessor.this.projectDataFactory.updateProject(DefaultFisheyeAccessor.this.projectManager, projectData);
                return null;
            }
        });
    }

    @Override
    public ProjectData getProjectByKey(String key) {
        Project project = this.projectManager.getProjectByKey(key);
        if (project == null) {
            return null;
        }
        return new ProjectData(project);
    }

    @Override
    public int updateCrucibleMetrics(final String xml) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            return this.txTemplate.execute(new TxCallback<Integer>(){

                @Override
                public Integer doInTransaction(TransactionStatus transactionStatus) throws Exception {
                    return MetricsManager.INSTANCE.storeNewConfig(xml, false);
                }
            });
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof XMLValidationException) {
                throw new FisheyeAccessor.FisheyeAccessorException("XML failed validation", re);
            }
            throw new FisheyeAccessor.FisheyeAccessorException("Error updating Crucible metrics", re);
        }
    }

    @Override
    public String getCrucibleMetrics() {
        return MetricsManager.INSTANCE.getConfigDef(MetricsManager.INSTANCE.getLatestVersion()).getXml();
    }

    @Override
    public void addSysadminGroup(String groupname) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            this.adminUserConfig.addGroup(groupname);
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            throw new FisheyeAccessor.FisheyeAccessorException("IOException occured while trying to add sysadmin group: " + groupname, e2);
        }
    }

    @Override
    public Collection<String> getUsersInGroup(String groupname) throws FisheyeAccessor.FisheyeAccessorException {
        try {
            return SpringContext.getComponentByClass(GroupMembershipManager.class).getUsersInGroup(groupname).stream().map(user -> user.getUsername()).collect(Collectors.toList());
        }
        catch (DbException e2) {
            throw new FisheyeAccessor.FisheyeAccessorException("Exception occured while retrieving users for group: " + groupname, e2);
        }
    }
}

