/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.sal.pluginsettings;

import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.atlassian.fecru.sal.pluginsettings.FisheyePluginSettings;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.cenqua.fisheye.config.RepositoryManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="salPluginSettingsFactory")
@AvailableToPlugins
public class FisheyePluginSettingsFactory
implements PluginSettingsFactory {
    private final RepositoryPropertyManager repositoryPropertyManager;
    private final RepositoryManager repositoryManager;

    @Autowired
    public FisheyePluginSettingsFactory(RepositoryPropertyManager repositoryPropertyManager, RepositoryManager repositoryManager) {
        this.repositoryPropertyManager = repositoryPropertyManager;
        this.repositoryManager = repositoryManager;
    }

    public PluginSettings createSettingsForKey(String key) {
        String repository = null;
        if (key != null && key.trim().length() != 0) {
            if (this.repositoryManager.getRepository(key) != null) {
                repository = key;
            } else {
                throw new IllegalArgumentException("Repository handle for repository '" + key + "' not found.");
            }
        }
        return new FisheyePluginSettings(this.repositoryPropertyManager, repository);
    }

    public PluginSettings createGlobalSettings() {
        return this.createSettingsForKey(null);
    }
}

