/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.sal.pluginsettings;

import com.atlassian.fecru.sal.pluginsettings.appconfig.FisheyeAccessor;
import com.atlassian.fisheye.web.SiteUrlBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.util.VersionNumber;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="applicationProperties")
@AvailableToPlugins
public class FisheyeApplicationProperties
implements ApplicationProperties {
    private final FisheyeAccessor fisheyeAccessor;
    private final FisheyeVersionInfo fisheyeVersionInfo = new FisheyeVersionInfo();
    private final SiteUrlBuilder siteUrlBuilder;
    private VersionNumber versionNumber = new VersionNumber(this.fisheyeVersionInfo.getReleaseNum());

    @Autowired
    public FisheyeApplicationProperties(FisheyeAccessor fisheyeAccessor, SiteUrlBuilder siteUrlBuilder) {
        this.fisheyeAccessor = fisheyeAccessor;
        this.siteUrlBuilder = siteUrlBuilder;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.CANONICAL);
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case CANONICAL: {
                return this.siteUrlBuilder.getConfiguredSiteURL();
            }
            case ABSOLUTE: {
                return this.siteUrlBuilder.getSiteUrl();
            }
            case RELATIVE: {
                return this.siteUrlBuilder.getSiteContextPath(true);
            }
            case RELATIVE_CANONICAL: {
                return this.siteUrlBuilder.getSiteContextPath(false);
            }
            case AUTO: {
                return this.siteUrlBuilder.getSiteContextPathOrUrl();
            }
        }
        throw new UnsupportedOperationException("Not implemented yet for " + urlMode);
    }

    public String getDisplayName() {
        return "FishEye";
    }

    public String getPlatformId() {
        return "fisheye";
    }

    public String getVersion() {
        return this.fisheyeVersionInfo.getReleaseNum();
    }

    public Date getBuildDate() {
        String buildDateFormat = "yyyy-MM-dd";
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(this.fisheyeVersionInfo.getBuildDate());
        }
        catch (ParseException e2) {
            throw new RuntimeException("Unable to parse FishEye build date <" + this.fisheyeVersionInfo.getBuildDate() + "> into format " + "yyyy-MM-dd", e2);
        }
    }

    public String getBuildNumber() {
        return Integer.toString(this.versionNumber.toInteger());
    }

    public File getHomeDirectory() {
        return this.fisheyeAccessor.getInstanceDirectory();
    }

    public String getPropertyValue(String key) {
        return null;
    }
}

