/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.sal.pluginsettings;

import com.atlassian.fecru.sal.pluginsettings.EscapeUtils;
import com.atlassian.fisheye.util.DevMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public abstract class FishEyeStringPluginSettings
implements PluginSettings {
    private static final Logger log = Logger.getLogger(FishEyeStringPluginSettings.class);
    private static final String PROPERTIES_ENCODING = "ISO8859_1";
    private static final String PROPERTIES_IDENTIFIER = "java.util.Properties";
    private static final String LIST_IDENTIFIER = "#java.util.List";
    private static final String MAP_IDENTIFIER = "#java.util.Map";
    private final boolean isDeveloperMode = DevMode.isAtlassianDevMode();

    public Object put(String key, Object value) {
        Validate.notNull((Object)key, (String)"The plugin settings key cannot be null");
        Validate.isTrue((key.length() <= 255 ? 1 : 0) != 0, (String)"The plugin settings key cannot be more than 255 characters");
        if (this.isDeveloperMode) {
            Validate.isTrue((key.length() <= 100 ? 1 : 0) != 0, (String)"The plugin settings key cannot be more than 100 characters in developer mode");
        }
        if (value == null) {
            return this.remove(key);
        }
        Object oldValue = this.get(key);
        if (value instanceof Properties) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                Properties properties = (Properties)value;
                properties.store(bout, PROPERTIES_IDENTIFIER);
                this.putActual(key, new String(bout.toByteArray(), PROPERTIES_ENCODING));
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("Unable to serialize properties", e2);
            }
        } else if (value instanceof String) {
            this.putActual(key, (String)value);
        } else if (value instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append(LIST_IDENTIFIER).append('\n');
            Iterator i2 = ((List)value).iterator();
            while (i2.hasNext()) {
                sb.append(EscapeUtils.escape(i2.next().toString()));
                if (!i2.hasNext()) continue;
                sb.append('\n');
            }
            this.putActual(key, sb.toString());
        } else if (value instanceof Map) {
            StringBuilder sb = new StringBuilder();
            sb.append(MAP_IDENTIFIER).append('\n');
            Iterator i3 = ((Map)value).entrySet().iterator();
            while (i3.hasNext()) {
                Map.Entry entry = i3.next();
                sb.append(EscapeUtils.escape(entry.getKey().toString()));
                sb.append('\f');
                sb.append(EscapeUtils.escape(entry.getValue().toString()));
                if (!i3.hasNext()) continue;
                sb.append('\n');
            }
            this.putActual(key, sb.toString());
        } else {
            throw new IllegalArgumentException("Property type: " + value.getClass() + " not supported");
        }
        return oldValue;
    }

    public Object get(String key) {
        String val;
        Validate.notNull((Object)key, (String)"The plugin settings key cannot be null");
        if (this.isDeveloperMode && key.length() > 100) {
            log.warn((Object)("PluginSettings.get with excessive key length: " + key));
        }
        if ((val = this.getActual(key)) != null && val.startsWith("#java.util.Properties")) {
            Properties p2 = new Properties();
            try {
                p2.load(new ByteArrayInputStream(val.getBytes(PROPERTIES_ENCODING)));
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("Unable to deserialize properties", e2);
            }
            return p2;
        }
        if (val != null && val.startsWith(LIST_IDENTIFIER)) {
            String[] lines = val.split("\n");
            List<String> rawItems = Arrays.asList(lines).subList(1, lines.length);
            List items = Lists.transform(rawItems, (Function)new Function<String, String>(){

                public String apply(String from) {
                    return EscapeUtils.unescape(from);
                }
            });
            return new ArrayList(items);
        }
        if (val != null && val.startsWith(MAP_IDENTIFIER)) {
            String[] items;
            String nval = val.substring(MAP_IDENTIFIER.length() + 1);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String item : items = nval.split("\n")) {
                if (item.length() <= 0) continue;
                String[] pair = item.split("\f");
                if (pair.length != 2) {
                    log.error((Object)("Could not parse map element: << " + item + " >> \n" + "Full list: \n" + nval));
                    continue;
                }
                map.put(EscapeUtils.unescape(pair[0]), EscapeUtils.unescape(pair[1]));
            }
            return map;
        }
        return val;
    }

    public Object remove(String key) {
        Object oldValue;
        Validate.notNull((Object)key, (String)"The plugin settings key cannot be null");
        if (this.isDeveloperMode && key.length() > 100) {
            log.warn((Object)("PluginSettings.get with excessive key length: " + key));
        }
        if ((oldValue = this.get(key)) != null) {
            this.removeActual(key);
        }
        return oldValue;
    }

    protected abstract void putActual(String var1, String var2);

    protected abstract String getActual(String var1);

    protected abstract void removeActual(String var1);
}

