/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review.store.data;

import com.atlassian.fecru.review.store.data.CoreReviewData;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import javax.annotation.Nullable;

public class CoreReviewDataConverter {
    public static Function<Review, CoreReviewData> fromReview() {
        return new Function<Review, CoreReviewData>(){

            @Nullable
            public CoreReviewData apply(@Nullable Review review) {
                if (review == null) {
                    return null;
                }
                return new CoreReviewData.Builder().id(review.getId()).permId(review.getPermaId()).projectKey(review.getProject()).defaultSource(review.getDefaultSource()).type(review.getType()).permaIdHistory((ImmutableList<String>)ImmutableList.copyOf((Iterable)Iterables.transform(review.getPermaIdHistory(), (Function)Functions.compose((Function)Functions.toStringFunction(), ReviewPermaId.GET_PERMA_ID_KEY)))).name(review.getName()).summary(review.getSummary()).description(review.getDescription()).stateName(review.getStateName()).creatorName(review.getCreator()).createDate(review.getCreateDate()).reminderDate(review.getReminderDate()).dueDate(review.getDueDate()).parentReviewPermId(review.getParentReview()).metricsVersion(review.getMetricsVersion()).jiraIssueKey(review.getJiraIssueKey()).allowReviewerToJoin(review.isAllowReviewerToJoin()).build();
            }
        };
    }

    private static Function<String, ReviewPermaId> toReviewPermaId(final Review review) {
        return new Function<String, ReviewPermaId>(){

            @Nullable
            public ReviewPermaId apply(@Nullable String reviewPermaIdString) {
                if (reviewPermaIdString == null) {
                    return null;
                }
                PermaIdKey permaIdKey = PermaIdKey.parsePermaId(reviewPermaIdString);
                ReviewPermaId reviewPermaId = new ReviewPermaId(review, permaIdKey);
                return reviewPermaId;
            }
        };
    }

    public static Function<CoreReviewData, Review> toReview(final ProjectDAO projectDAO, final ReviewDAO reviewDAO, final FecruUserDAO userDAO) {
        return new Function<CoreReviewData, Review>(){

            @Nullable
            public Review apply(@Nullable CoreReviewData coreReviewData) {
                if (coreReviewData == null) {
                    return null;
                }
                Project project = projectDAO.getByKey(coreReviewData.projectKey);
                if (project == null) {
                    throw new IllegalArgumentException("Could not find project with key: " + coreReviewData.projectKey);
                }
                Review.ReviewType reviewType = Review.ReviewType.fromApiReviewType(coreReviewData.type);
                Review review = new Review(null, project, reviewType, coreReviewData.name);
                review.setId(coreReviewData.id);
                ImmutableList.Builder permaIdHistory = new ImmutableList.Builder();
                if (coreReviewData.permId != null) {
                    permaIdHistory.add(CoreReviewDataConverter.toReviewPermaId(review).apply((Object)coreReviewData.permId));
                }
                if (coreReviewData.permaIdHistory != null) {
                    permaIdHistory.addAll(Iterables.transform(coreReviewData.permaIdHistory, (Function)CoreReviewDataConverter.toReviewPermaId(review)));
                }
                review.setPermaIdHistory(Sets.newLinkedHashSet((Iterable)permaIdHistory.build()));
                review.setDefaultSource(coreReviewData.defaultSource);
                review.setSummary(coreReviewData.summary);
                review.setDescription(coreReviewData.description);
                review.setStateName(coreReviewData.stateName);
                FecruUser creatorUser = userDAO.getByUsername(coreReviewData.creatorName);
                if (creatorUser == null) {
                    throw new IllegalArgumentException("Could not find user with creatorName: " + coreReviewData.creatorName);
                }
                review.setCreator(creatorUser);
                review.setCreateDate(coreReviewData.createDate);
                review.setReminderDate(coreReviewData.reminderDate);
                review.setDueDate(coreReviewData.dueDate);
                if (coreReviewData.parentReviewPermId != null) {
                    Review parentReview = reviewDAO.getReviewByPermaId(PermaIdKey.parsePermaId(coreReviewData.parentReviewPermId));
                    if (parentReview == null) {
                        throw new IllegalArgumentException("Could not find review with parentReviewPermId: " + coreReviewData.parentReviewPermId);
                    }
                    review.setParentReview(parentReview);
                }
                review.setMetricsVersion(coreReviewData.metricsVersion);
                review.setJiraIssueKey(coreReviewData.jiraIssueKey);
                review.setAllowReviewerToJoin(coreReviewData.allowReviewerToJoin);
                return review;
            }
        };
    }
}

