/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review.store.data;

import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.google.common.collect.ImmutableList;
import java.util.Date;

public class CoreReviewData {
    public final Integer id;
    public final String permId;
    public final String projectKey;
    public final String defaultSource;
    public final ReviewData.ReviewType type;
    public final ImmutableList<String> permaIdHistory;
    public final String name;
    public final String summary;
    public final String description;
    public final String stateName;
    public final String creatorName;
    public final Date createDate;
    public final Date reminderDate;
    public final Date dueDate;
    public final String parentReviewPermId;
    public final Integer metricsVersion;
    public final String jiraIssueKey;
    public final Boolean allowReviewerToJoin;

    private CoreReviewData(Integer id, String permId, String projectKey, String defaultSource, ReviewData.ReviewType type, ImmutableList<String> permaIdHistory, String name, String summary, String description, String stateName, String creatorName, Date createDate, Date reminderDate, Date dueDate, String parentReviewPermId, Integer metricsVersion, String jiraIssueKey, Boolean allowReviewerToJoin) {
        this.id = id;
        this.permId = permId;
        this.projectKey = projectKey;
        this.defaultSource = defaultSource;
        this.type = type;
        this.permaIdHistory = permaIdHistory;
        this.name = name;
        this.summary = summary;
        this.description = description;
        this.stateName = stateName;
        this.creatorName = creatorName;
        this.createDate = createDate;
        this.reminderDate = reminderDate;
        this.dueDate = dueDate;
        this.parentReviewPermId = parentReviewPermId;
        this.metricsVersion = metricsVersion;
        this.jiraIssueKey = jiraIssueKey;
        this.allowReviewerToJoin = allowReviewerToJoin;
    }

    public static class Builder {
        private Integer id;
        private String permId;
        private String projectKey;
        private String defaultSource;
        private ReviewData.ReviewType type;
        private ImmutableList<String> permaIdHistory;
        private String name;
        private String summary;
        private String description;
        private String stateName;
        private String creatorName;
        private Date createDate;
        private Date reminderDate;
        private Date dueDate;
        private String parentReviewPermId;
        private Integer metricsVersion;
        private String jiraIssueKey;
        private Boolean allowReviewerToJoin;

        public Builder copy(CoreReviewData coreReviewData) {
            this.id = coreReviewData.id;
            this.permId = coreReviewData.permId;
            this.projectKey = coreReviewData.projectKey;
            this.defaultSource = coreReviewData.defaultSource;
            this.type = coreReviewData.type;
            this.permaIdHistory = coreReviewData.permaIdHistory;
            this.name = coreReviewData.name;
            this.summary = coreReviewData.summary;
            this.description = coreReviewData.description;
            this.stateName = coreReviewData.stateName;
            this.creatorName = coreReviewData.creatorName;
            this.createDate = coreReviewData.createDate;
            this.reminderDate = coreReviewData.reminderDate;
            this.dueDate = coreReviewData.dueDate;
            this.parentReviewPermId = coreReviewData.parentReviewPermId;
            this.metricsVersion = coreReviewData.metricsVersion;
            this.jiraIssueKey = coreReviewData.jiraIssueKey;
            this.allowReviewerToJoin = coreReviewData.allowReviewerToJoin;
            return this;
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder permId(String permId) {
            this.permId = permId;
            return this;
        }

        public Builder projectKey(Project project) {
            if (project != null) {
                return this.projectKey(project.getProjKey());
            }
            return this;
        }

        public Builder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public Builder defaultSource(String defaultSource) {
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder type(ReviewData.ReviewType type) {
            this.type = type;
            return this;
        }

        public Builder type(Review.ReviewType reviewType) {
            if (reviewType != null) {
                return this.type(reviewType.getApiReviewType());
            }
            return this;
        }

        public Builder permaIdHistory(ImmutableList<String> permaIdHistory) {
            this.permaIdHistory = permaIdHistory;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public Builder creatorName(FecruUser user) {
            if (user != null) {
                this.creatorName(user.getUsername());
            }
            return this;
        }

        public Builder creatorName(String creatorName) {
            this.creatorName = creatorName;
            return this;
        }

        public Builder createDate(Date createDate) {
            this.createDate = createDate;
            return this;
        }

        public Builder reminderDate(Date reminderDate) {
            this.reminderDate = reminderDate;
            return this;
        }

        public Builder dueDate(Date dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder parentReviewPermId(Review parentReview) {
            if (parentReview != null) {
                return this.parentReviewPermId(parentReview.getPermaId());
            }
            return this;
        }

        public Builder parentReviewPermId(String parentReviewPermId) {
            this.parentReviewPermId = parentReviewPermId;
            return this;
        }

        public Builder metricsVersion(Integer metricsVersion) {
            this.metricsVersion = metricsVersion;
            return this;
        }

        public Builder jiraIssueKey(String jiraIssueKey) {
            this.jiraIssueKey = jiraIssueKey;
            return this;
        }

        public Builder allowReviewerToJoin(Boolean allowReviewerToJoin) {
            this.allowReviewerToJoin = allowReviewerToJoin;
            return this;
        }

        public CoreReviewData build() {
            return new CoreReviewData(this.id, this.permId, this.projectKey, this.defaultSource, this.type, this.permaIdHistory, this.name, this.summary, this.description, this.stateName, this.creatorName, this.createDate, this.reminderDate, this.dueDate, this.parentReviewPermId, this.metricsVersion, this.jiraIssueKey, this.allowReviewerToJoin);
        }
    }
}

