/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review.store;

import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResource;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fecru.review.store.ReviewDataManager;
import com.atlassian.fecru.review.store.data.CoreReviewData;
import com.atlassian.fecru.review.store.data.CoreReviewDataConverter;
import com.atlassian.fecru.tx.NonTransactional;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reviewDataManager")
public class DefaultReviewDataManager
implements ReviewDataManager {
    private final ProjectDAO projectDAO;
    private final ReviewDAO reviewDAO;
    private final FecruUserDAO userDAO;
    @Resource(name="reviewDataManager")
    private ReviewDataManager self;

    @Autowired
    public DefaultReviewDataManager(ProjectDAO projectDAO, ReviewDAO reviewDAO, FecruUserDAO userDAO) {
        this.projectDAO = projectDAO;
        this.reviewDAO = reviewDAO;
        this.userDAO = userDAO;
    }

    @Override
    @Transactional
    public void createReviewsFrom(Iterable<CoreReviewData> coreReviewDataList) {
        for (CoreReviewData coreReviewData : coreReviewDataList) {
            this.self.createReviewFrom(coreReviewData);
        }
    }

    @Override
    @Transactional
    public void createReviewFrom(CoreReviewData coreReviewData) {
        Review review = (Review)CoreReviewDataConverter.toReview(this.projectDAO, this.reviewDAO, this.userDAO).apply((Object)coreReviewData);
        this.reviewDAO.add(review);
    }

    @Override
    @Transactional
    public Page<CoreReviewData> getCoreReviewDataPageForProject(String projectKey, PageRequest pageRequest) {
        Project project = this.projectDAO.ensureProjectExists(projectKey);
        List<Review> reviewsPlusOne = this.reviewDAO.listWithProject(project, pageRequest.getStart(), pageRequest.getLimit() + 1);
        Page pageOfReviews = Page.Builder.buildFromLimitPlusOneCollection(reviewsPlusOne, (PageRequest)pageRequest);
        return pageOfReviews.transform(CoreReviewDataConverter.fromReview());
    }

    @Override
    @NonTransactional
    public Iterable<CoreReviewData> getCoreReviewDataIterableForProject(final String projectKey, PageRequest firstPageRequest) {
        return new PagedResourceIterable<CoreReviewData>(new PagedResource<CoreReviewData>(){

            @Override
            public Page<CoreReviewData> getPage(PageRequest pageRequest) {
                return DefaultReviewDataManager.this.self.getCoreReviewDataPageForProject(projectKey, pageRequest);
            }
        }, firstPageRequest);
    }
}

