/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review;

import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.util.concurrent.Striped;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class StripedLockReviewLockManager
implements ReviewLockManager {
    private final Striped<Lock> locks = Striped.lazyWeakLock((int)0x40000001);

    @Override
    public <T> T withReviewLock(Review review, Callable<T> operation) {
        Lock l2 = this.lock(review.getId());
        try {
            T t2 = operation.call();
            return t2;
        }
        catch (Exception e2) {
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
        finally {
            l2.unlock();
        }
    }

    private Lock lock(int reviewId) {
        Lock lock = (Lock)this.locks.get((Object)reviewId);
        try {
            Pair<Integer, TimeUnit> timeout = this.getTimeout();
            if (!lock.tryLock(((Integer)timeout.left()).intValue(), (TimeUnit)((Object)timeout.right()))) {
                String errorMessage = "Timed out waiting to lock Review " + reviewId;
                Logs.APP_LOG.error((Object)errorMessage);
                throw new RuntimeException(errorMessage);
            }
            return lock;
        }
        catch (InterruptedException e2) {
            String errorMessage = "Interrupted while waiting to lock Review " + reviewId;
            Logs.APP_LOG.error((Object)errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    protected Pair<Integer, TimeUnit> getTimeout() {
        return Pair.pair((Object)10, (Object)((Object)TimeUnit.MINUTES));
    }
}

