/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.review;

import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ParticipantDAOImpl
implements ParticipantDAO {
    private CurrentSessionProvider sessionProvider;

    @Autowired
    public ParticipantDAOImpl(CurrentSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    private Session session() {
        return this.sessionProvider.currentSession();
    }

    @Override
    public ReviewParticipant getById(int id) {
        return (ReviewParticipant)this.session().get(ReviewParticipant.class, (Serializable)Integer.valueOf(id));
    }

    @Override
    public List<ReviewParticipant> getByIds(Collection<Integer> ids) {
        Query q2 = this.session().createQuery("from ReviewParticipant reviewParticipant where reviewParticipant.id in (:ids)");
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(q2, "ids", ImmutableList.copyOf(ids));
        return helper.executeAndFetchAll();
    }

    @Override
    public void deleteParticipant(ReviewParticipant reviewParticipant) {
        for (FileReadStatus status : reviewParticipant.getFileReadStatus()) {
            this.session().delete((Object)status);
        }
        reviewParticipant.getFileReadStatus().clear();
        this.session().delete((Object)reviewParticipant);
    }

    @Override
    public ReviewParticipant getOrCreateParticipant(Review review, FecruUser user) {
        ReviewParticipant reviewParticipant = review.getParticipant(user);
        if (reviewParticipant != null) {
            return reviewParticipant;
        }
        reviewParticipant = new ReviewParticipant();
        reviewParticipant.setReview(review);
        reviewParticipant.setUser(user);
        this.session().save((Object)reviewParticipant);
        review.getParticipants().add(reviewParticipant);
        return reviewParticipant;
    }
}

