/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.properties;

import com.atlassian.fecru.properties.UserRepositoryProperty;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins
@Component(value="userRepositoryPropertyManager")
@Transactional
public class UserRepositoryPropertyManagerImpl
implements UserRepositoryPropertyManager {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public UserRepositoryPropertyManagerImpl(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public Map<String, String> loadProperties(FecruUser user, String repository) {
        Query q2 = this.session().createQuery("from UserRepositoryProperty where user = :user and repository = :repository");
        q2.setEntity("user", (Object)user);
        q2.setString("repository", repository);
        List list = q2.list();
        HashMap<String, String> map = new HashMap<String, String>();
        for (UserRepositoryProperty prop : list) {
            map.put(prop.getPropertyName(), prop.getValue());
        }
        return map;
    }

    @Override
    public Map<String, String> loadGlobalProperties(FecruUser user) {
        return this.loadProperties(user, "<ALL_REPOS>");
    }

    private UserRepositoryProperty loadPropertyObject(FecruUser user, String repository, String propertyName) {
        Query q2 = this.session().createQuery("from UserRepositoryProperty where user = :user and repository = :repository and propertyName = :propertyName");
        q2.setEntity("user", (Object)user);
        q2.setString("repository", repository);
        q2.setString("propertyName", propertyName);
        return (UserRepositoryProperty)q2.uniqueResult();
    }

    @Override
    public String loadProperty(FecruUser user, String repository, String propertyName) {
        UserRepositoryProperty property = this.loadPropertyObject(user, repository, propertyName);
        return property == null ? null : property.getValue();
    }

    @Override
    public String loadGlobalProperty(FecruUser user, String propertyName) {
        return this.loadProperty(user, "<ALL_REPOS>", propertyName);
    }

    @Override
    public void saveProperties(FecruUser user, String repository, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.saveProperty(user, repository, property.getKey(), property.getValue());
        }
    }

    @Override
    public void saveGlobalProperties(FecruUser user, Map<String, String> properties) {
        this.saveProperties(user, "<ALL_REPOS>", properties);
    }

    @Override
    public void removeProperty(FecruUser user, String repository, String propertyName) {
        UserRepositoryProperty property = this.loadPropertyObject(user, repository, propertyName);
        if (property != null) {
            this.session().delete((Object)property);
        }
    }

    @Override
    public void removeGlobalProperty(FecruUser user, String propertyName) {
        this.removeProperty(user, "<ALL_REPOS>", propertyName);
    }

    @Override
    public void deleteUserProperties(FecruUser user) {
        Query query = this.session().createQuery("delete from UserRepositoryProperty where user = :user");
        query.setEntity("user", (Object)user);
        query.executeUpdate();
    }

    @Override
    public void saveProperty(FecruUser user, String repository, String propertyName, String value) {
        UserRepositoryProperty property = this.loadPropertyObject(user, repository, propertyName);
        if (property == null) {
            property = new UserRepositoryProperty(user, repository, propertyName, value);
        } else {
            property.setValue(value);
        }
        this.saveProperty(property);
    }

    @Override
    public void saveGlobalProperty(FecruUser user, String propertyName, String value) {
        this.saveProperty(user, "<ALL_REPOS>", propertyName, value);
    }

    private void saveProperty(UserRepositoryProperty property) {
        this.session().saveOrUpdate((Object)property);
    }
}

