/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.properties;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.properties.RepositoryProperty;
import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.atlassian.fisheye.event.RepositoryDeletedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.WithSession;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component(value="repositoryPropertyManager")
@AvailableToPlugins(value=RepositoryPropertyManager.class)
@WithSession
public class RepositoryPropertyManagerImpl
implements RepositoryPropertyManager {
    private final TxTemplate txTemplate;
    private final EventPublisher eventPublisher;
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public RepositoryPropertyManagerImpl(TxTemplate txTemplate, EventPublisher eventPublisher, CurrentSessionProvider currentSessionProvider) {
        this.txTemplate = txTemplate;
        this.eventPublisher = eventPublisher;
        this.currentSessionProvider = currentSessionProvider;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    private RepositoryProperty loadPropertyObject(String repository, String propertyName) {
        Query q2 = this.session().createQuery("from RepositoryProperty where repository = :repository and propertyName = :propertyName").setCacheable(true);
        q2.setString("repository", repository);
        q2.setString("propertyName", propertyName);
        return (RepositoryProperty)q2.uniqueResult();
    }

    @Override
    public String loadProperty(String repository, String propertyName) {
        RepositoryProperty property = this.loadPropertyObject(repository, propertyName);
        return property == null ? null : property.getValue();
    }

    @Override
    public String loadGlobalProperty(String propertyName) {
        return this.loadProperty("<ALL_REPOS>", propertyName);
    }

    @Override
    public boolean removeProperty(final String repository, final String propertyName) {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                Query q2 = RepositoryPropertyManagerImpl.this.session().createQuery("delete RepositoryProperty where repository = :repository and propertyName = :propertyName");
                q2.setString("repository", repository);
                q2.setString("propertyName", propertyName);
                int rows = q2.executeUpdate();
                return rows > 0;
            }
        });
    }

    @Override
    public boolean removeGlobalProperty(String propertyName) {
        return this.removeProperty("<ALL_REPOS>", propertyName);
    }

    @Override
    public void saveProperty(String repository, String propertyName, String value) {
        RepositoryProperty property = this.loadPropertyObject(repository, propertyName);
        if (property == null) {
            property = new RepositoryProperty(repository, propertyName, value);
        } else {
            property.setValue(value);
        }
        this.saveProperty(property);
    }

    @Override
    public void saveGlobalProperty(String propertyName, String value) {
        this.saveProperty("<ALL_REPOS>", propertyName, value);
    }

    @EventListener
    public void onRepositoryDeleted(final RepositoryDeletedEvent repositoryDeletedEvent) {
        this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                Query q2 = RepositoryPropertyManagerImpl.this.session().createQuery("delete RepositoryProperty where repository = :repository");
                q2.setString("repository", repositoryDeletedEvent.getRepositoryName());
                q2.executeUpdate();
                return null;
            }
        });
    }

    private void saveProperty(final RepositoryProperty property) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                RepositoryPropertyManagerImpl.this.session().saveOrUpdate((Object)property);
                return null;
            }
        });
    }
}

