/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.properties;

import com.cenqua.fisheye.util.HashUtils;
import java.io.Serializable;

public class RepositoryProperty
implements Serializable {
    private Integer id;
    private String repository;
    private String propertyName;
    private String hash;
    private String value;

    public RepositoryProperty() {
    }

    public RepositoryProperty(String repository, String propertyName, String value) {
        this.repository = repository;
        this.propertyName = propertyName;
        this.value = value;
        this.hash = this.generateHash(repository, propertyName);
    }

    private String generateHash(String repository, String propertyName) {
        return HashUtils.getDefaultDigestHexEncoded(repository + ":" + propertyName);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "RepositoryProperty{id=" + this.id + ", repository='" + this.repository + '\'' + ", propertyName='" + this.propertyName + '\'' + ", hash='" + this.hash + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RepositoryProperty that = (RepositoryProperty)o2;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

