/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.profiling;

import com.atlassian.fecru.profiling.MemoryAllocationTracker;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.ServletUtils;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;
import org.springframework.stereotype.Component;

@Component(value="profilingFilter")
public class ProfilingServletFilter
implements Filter {
    private static final Set<String> censoredUrlParams = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"password", "adminPassword", "dbConfig.password"}));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block4: {
            block3: {
                if (!(req instanceof HttpServletRequest)) break block3;
                HttpServletResponse response = (HttpServletResponse)res;
                HttpServletRequest request = (HttpServletRequest)req;
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                MemoryAllocationTracker mat = new MemoryAllocationTracker();
                boolean debugEnabled = this.isDebugEnabled();
                if (debugEnabled) {
                    mat.start();
                }
                this.logRequest("start request", request, response, Optional.empty());
                try {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    this.logRequest("end request in " + stopWatch.getTime() + "ms", request, response, debugEnabled ? mat.stop() : Optional.empty());
                }
                catch (Throwable throwable) {
                    this.logRequest("end request in " + stopWatch.getTime() + "ms", request, response, debugEnabled ? mat.stop() : Optional.empty());
                    throw throwable;
                }
                break block4;
            }
            chain.doFilter(req, res);
        }
    }

    private void logRequest(String msg, HttpServletRequest request, HttpServletResponse response, Optional<Long> threadMemoryAllocation) {
        if (this.isDebugEnabled()) {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            Iterators.forEnumeration((Enumeration)request.getParameterNames()).forEachRemaining(name -> {
                String[] values = request.getParameterValues(name);
                for (int i2 = 0; i2 < values.length; ++i2) {
                    if (!censoredUrlParams.contains(name)) continue;
                    values[i2] = "XXXX";
                }
                params.put((String)name, values);
            });
            HttpSession session = request.getSession(false);
            StringBuilder sb = new StringBuilder(256);
            sb.append(request.getMethod()).append(" ").append(request.getRequestURI()).append(ServletUtils.toQueryString(params));
            if (null != session) {
                sb.append(" sessionid=").append(session.getId());
            } else {
                sb.append(" nosession");
            }
            if (response.isCommitted()) {
                sb.append(" ").append(response.getStatus());
            }
            sb.append(threadMemoryAllocation.map(allocation -> String.format(" mem=%.3fMB", (double)((Long)threadMemoryAllocation.get()).longValue() / 1024.0 / 1024.0)).orElse(""));
            sb.insert(0, " ").insert(0, msg);
            Logs.APP_LOG.debug((Object)sb.toString());
        }
    }

    private boolean isDebugEnabled() {
        return Logs.APP_LOG.isDebugEnabled();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

