/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.profiling;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.concurrent.NotThreadSafe;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

@NotThreadSafe
public class MemoryAllocationTracker {
    private static final Optional<ObjectName> THREAD_MXBEAN_OBJECT_NAME;
    public static final int MEMORY_ALLOCATION_INVALID = -1;
    private static final Predicate<MBeanServer> IS_THREAD_ALLOCATED_MEMORY_ENABLED;
    private static final Predicate<MBeanServer> IS_THREAD_ALLOCATED_MEMORY_SUPPORTED;
    private static final Function<MBeanServerAndThreadId, Optional<ThreadMemoryAllocation>> MBEAN_SERVER_AND_THREAD_ID_TO_MEMORY_ALLOCATION;
    private static final Optional<MBeanServer> PLATFORM_MBEAN_SERVER;
    private Optional<ThreadMemoryAllocation> allocationAtStart;

    public void start() {
        this.allocationAtStart = this.getThreadMemoryAllocation();
    }

    public Optional<Long> stop() {
        Preconditions.checkState((null != this.allocationAtStart ? 1 : 0) != 0, (Object)"not started yet");
        if (!this.allocationAtStart.isPresent()) {
            return Optional.empty();
        }
        Optional<ThreadMemoryAllocation> allocationAtStop = this.getThreadMemoryAllocation();
        if (!allocationAtStop.isPresent()) {
            return Optional.empty();
        }
        Preconditions.checkState((this.allocationAtStart.get().threadId == allocationAtStop.get().threadId ? 1 : 0) != 0, (Object)"should be called from the same thread");
        return Optional.of(allocationAtStop.get().memoryAllocation - this.allocationAtStart.get().memoryAllocation);
    }

    private Optional<ThreadMemoryAllocation> getThreadMemoryAllocation() {
        return PLATFORM_MBEAN_SERVER.filter(IS_THREAD_ALLOCATED_MEMORY_ENABLED).map(mBeanServer -> new MBeanServerAndThreadId((MBeanServer)mBeanServer, MemoryAllocationTracker.getCurrentThreadId())).flatMap(MBEAN_SERVER_AND_THREAD_ID_TO_MEMORY_ALLOCATION);
    }

    private static long getCurrentThreadId() {
        return Thread.currentThread().getId();
    }

    private static Optional<Boolean> getBooleanAttribute(MBeanServer mBeanServer, ObjectName beanName, String attribute) {
        try {
            return Optional.of((Boolean)mBeanServer.getAttribute(beanName, attribute));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e2) {
            Logs.APP_LOG.warn((Object)String.format("Failed to retrieve attribute %s of bean %s", attribute, beanName));
            return Optional.empty();
        }
    }

    private static Optional<ThreadMemoryAllocation> getThreadAllocatedBytes(MBeanServerAndThreadId mBeanServerAndThreadId, ObjectName objectName) {
        long allocation;
        try {
            allocation = (Long)mBeanServerAndThreadId.mBeanServer.invoke(objectName, "getThreadAllocatedBytes", new Object[]{mBeanServerAndThreadId.threadId}, new String[]{Long.TYPE.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e2) {
            Logs.APP_LOG.warn((Object)"Failed to retrieve thread allocated bytes");
            return Optional.empty();
        }
        return -1L == allocation ? Optional.empty() : Optional.of(new ThreadMemoryAllocation(allocation, mBeanServerAndThreadId.threadId));
    }

    static {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException e2) {
            Logs.APP_LOG.warn((Object)"Invalid format of bean name", (Throwable)e2);
        }
        THREAD_MXBEAN_OBJECT_NAME = Optional.ofNullable(objectName);
        IS_THREAD_ALLOCATED_MEMORY_ENABLED = mBeanServer -> THREAD_MXBEAN_OBJECT_NAME.flatMap(beanName -> MemoryAllocationTracker.getBooleanAttribute(mBeanServer, beanName, "ThreadAllocatedMemoryEnabled")).orElse(Boolean.FALSE);
        IS_THREAD_ALLOCATED_MEMORY_SUPPORTED = mBeanServer -> THREAD_MXBEAN_OBJECT_NAME.flatMap(beanName -> MemoryAllocationTracker.getBooleanAttribute(mBeanServer, beanName, "ThreadAllocatedMemorySupported")).orElse(Boolean.FALSE);
        MBEAN_SERVER_AND_THREAD_ID_TO_MEMORY_ALLOCATION = mBeanServerAndThreadId -> THREAD_MXBEAN_OBJECT_NAME.flatMap(beanName -> MemoryAllocationTracker.getThreadAllocatedBytes(mBeanServerAndThreadId, beanName));
        MBeanServer server = (MBeanServer)Preconditions.checkNotNull((Object)ManagementFactory.getPlatformMBeanServer());
        PLATFORM_MBEAN_SERVER = THREAD_MXBEAN_OBJECT_NAME.isPresent() && IS_THREAD_ALLOCATED_MEMORY_SUPPORTED.test(server) ? Optional.of(server) : Optional.empty();
    }

    private static class ThreadMemoryAllocation {
        public final long memoryAllocation;
        public final long threadId;

        public ThreadMemoryAllocation(long memoryAllocation, long threadId) {
            this.memoryAllocation = memoryAllocation;
            this.threadId = threadId;
        }
    }

    private static class MBeanServerAndThreadId {
        public final MBeanServer mBeanServer;
        public final long threadId;

        public MBeanServerAndThreadId(MBeanServer mBeanServer, long threadId) {
            this.mBeanServer = mBeanServer;
            this.threadId = threadId;
        }
    }
}

