/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.page;

import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResource;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public class PagedResourceIterable<T>
implements Iterable<T> {
    private final PagedResource<T> pagedService;
    private final PageRequest pageRequest;

    public PagedResourceIterable(PagedResource<T> pagedService) {
        this(pagedService, PageRequest.createDefault());
    }

    public PagedResourceIterable(PagedResource<T> pagedService, PageRequest firstPageRequest) {
        Preconditions.checkNotNull(pagedService);
        Preconditions.checkNotNull((Object)firstPageRequest);
        this.pagedService = pagedService;
        this.pageRequest = firstPageRequest;
    }

    @Override
    public Iterator<T> iterator() {
        return new PagedServiceIterator();
    }

    private class PagedServiceIterator
    implements Iterator<T> {
        private final PageRequest NA = null;
        private PageRequest nextPageRequest;
        private Iterator<T> currentValues = Iterators.emptyIterator();

        public PagedServiceIterator() {
            this.nextPageRequest = PagedResourceIterable.this.pageRequest;
        }

        @Override
        public boolean hasNext() {
            this.doPageRequestIfNeeded();
            return this.currentValues.hasNext();
        }

        private void doPageRequestIfNeeded() {
            if (!this.currentValues.hasNext()) {
                this.doPageRequest();
            }
        }

        private void doPageRequest() {
            if (this.nextPageRequest != this.NA) {
                Page page = PagedResourceIterable.this.pagedService.getPage(this.nextPageRequest);
                this.nextPageRequest = !page.isLastPage() ? page.getNextPageRequest() : this.NA;
                this.currentValues = page.getValues().iterator();
            }
        }

        @Override
        public T next() {
            this.doPageRequestIfNeeded();
            return this.currentValues.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

