/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.mentions;

import com.atlassian.crucible.event.ReviewEvent;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.mentions.NotificationCreatorMentionEventListener;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.event.UserMentionedEvent;
import com.atlassian.fisheye.event.UserMentionedEventVisitor;
import com.atlassian.fisheye.event.UserMentionedInChangesetCommentEvent;
import com.atlassian.fisheye.event.UserMentionedInReviewCommentEvent;
import com.atlassian.fisheye.event.UserMentionedInReviewDescriptionEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.MentionUserInChangesetCommentNotificationEvent;
import com.cenqua.crucible.notification.MentionUserInReviewCommentNotificationEvent;
import com.cenqua.crucible.notification.MentionUserInReviewDescriptionNotificationEvent;
import com.cenqua.crucible.notification.MentionUserNotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class DefaultNotificationCreatorMentionEventListener
implements NotificationCreatorMentionEventListener {
    private final EventPublisher eventPublisher;
    private final NotificationManager notificationManager;
    private final ReviewManager reviewManager;
    private final UserManager userManager;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultNotificationCreatorMentionEventListener(EventPublisher eventPublisher, NotificationManager notificationManager, UserManager userManager, TxTemplate txTemplate, ReviewManager reviewManager) {
        this.eventPublisher = eventPublisher;
        this.notificationManager = notificationManager;
        this.userManager = userManager;
        this.txTemplate = txTemplate;
        this.reviewManager = reviewManager;
        eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void userMentionedEventListener(final UserMentionedEvent e2) {
        final FecruUser mentioned = this.userManager.getLicensedUser(e2.getMentionedUserName());
        final FecruUser mentioning = this.userManager.getLicensedUser(e2.getMentioningUserName());
        if (mentioned == null) {
            Logs.APP_LOG.debug((Object)("mentioned user '" + e2.getMentionedUserName() + "' not found."));
        } else if (mentioning == null) {
            Logs.APP_LOG.debug((Object)("mentioning user '" + e2.getMentioningUserName() + "' not found."));
        } else {
            this.txTemplate.execute(new TxCallback<Void>(){

                @Override
                public Void doInTransaction(TransactionStatus status) throws Exception {
                    MentionUserNotificationEvent mentionEvent = (MentionUserNotificationEvent)e2.accept((UserMentionedEventVisitor)new UserMentionedEventVisitor<MentionUserNotificationEvent>(){

                        public MentionUserNotificationEvent visitUserMentionedInChangesetComment(UserMentionedInChangesetCommentEvent event) {
                            return new MentionUserInChangesetCommentNotificationEvent(mentioning, event.getCommentId().getId(), event.getUrl(), mentioned);
                        }

                        public MentionUserNotificationEvent visitUserMentionedInReviewComment(UserMentionedInReviewCommentEvent event) {
                            return new MentionUserInReviewCommentNotificationEvent(this.review((ReviewEvent)event), mentioning, event.getCommentId().getId(), event.getUrl(), mentioned);
                        }

                        public MentionUserNotificationEvent visitUserMentionedInReviewDescription(UserMentionedInReviewDescriptionEvent event) {
                            return new MentionUserInReviewDescriptionNotificationEvent(this.review((ReviewEvent)event), mentioning, event.getReviewId().getId(), event.getUrl(), mentioned);
                        }

                        private Review review(ReviewEvent e2) {
                            return DefaultNotificationCreatorMentionEventListener.this.reviewManager.getReviewByPermaId(e2.getReviewId().getId());
                        }
                    });
                    HibernateUtil.currentSession().save((Object)mentionEvent);
                    mentionEvent.doNotify();
                    return null;
                }
            });
        }
    }
}

