/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.mentions;

import com.atlassian.crucible.event.CommentCreatedEvent;
import com.atlassian.crucible.event.CommentUpdatedEvent;
import com.atlassian.crucible.event.ReviewCommentEvent;
import com.atlassian.crucible.event.ReviewDescriptionUpdatedEvent;
import com.atlassian.crucible.event.ReviewEvent;
import com.atlassian.crucible.event.ReviewStateChangedEvent;
import com.atlassian.crucible.event.cscomment.CsCommentCreatedEvent;
import com.atlassian.crucible.event.cscomment.CsCommentEvent;
import com.atlassian.crucible.event.cscomment.CsCommentUpdatedEvent;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.CsCommentData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.mentions.MentionParserListener;
import com.atlassian.fecru.mentions.UserMentionedInChangesetCommentEventImpl;
import com.atlassian.fecru.mentions.UserMentionedInReviewCommentEventImpl;
import com.atlassian.fecru.mentions.UserMentionedInReviewDescriptionEventImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.event.UserMentionedEvent;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.CommentOperator;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.fisheye.user.UserManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMentionParserListener
implements MentionParserListener {
    private final ChangesetCommentManager changesetCommentManager;
    private final ReviewManager reviewManager;
    private final EventPublisher eventPublisher;
    private static final Pattern AT_MENTION_REGEX = Pattern.compile("(?:^|\\s)@(\\S+)(?:$|\\s)");
    private static final Pattern TILDE_MENTION_REGEX = Pattern.compile("\\[~(\\S+?)\\]");
    private UserManager userManager;
    private final CommentManager commentManager;
    private final SPIUserUtils spiUserUtils;

    @Autowired
    public DefaultMentionParserListener(ChangesetCommentManager changesetCommentManager, ReviewManager reviewManager, EventPublisher eventPublisher, UserManager userManager, CommentManager commentManager, SPIUserUtils spiUserUtils) {
        this.changesetCommentManager = changesetCommentManager;
        this.reviewManager = reviewManager;
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.commentManager = commentManager;
        this.spiUserUtils = spiUserUtils;
        eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void csCommentCreatedEventListener(CsCommentCreatedEvent e2) {
        this.changesetComment((CsCommentEvent)e2, null);
    }

    @Override
    @EventListener
    public void csCommentUpdatedEventListener(CsCommentUpdatedEvent e2) {
        this.changesetComment((CsCommentEvent)e2, e2.getOldMessage());
    }

    @Override
    @EventListener
    public void commentCreatedEventListener(CommentCreatedEvent e2) {
        this.comment(this.getComment((ReviewCommentEvent)e2), e2.getActioner(), null, false);
    }

    private void changesetComment(CsCommentEvent e2, String oldText) {
        ChangesetComment comment = this.changesetCommentManager.getComment((PermId<CsCommentData>)e2.getCommentId());
        new ChangesetCommentTextProcessor(e2.getActioner(), comment.getMessage(), oldText, NavBuilder.changesetCommentAbs(comment), e2.getCommentId(), e2.getChangeSetId(), e2.getRepositoryName()).process();
    }

    private void comment(Comment comment, UserData actioner, String oldText, boolean wasDraft) {
        if (!comment.isDraft()) {
            new ReviewCommentTextProcessor(comment.getReview(), new PermId(comment.getPermaId()), this.spiUserUtils.createUserData(comment.getUser()), comment.getMessage(), oldText, NavBuilder.commentAbs(null, comment.getReview().getPermaId(), comment.getId()), wasDraft).process();
        }
    }

    private void reviewDescription(ReviewEvent e2, String previousDescription) {
        Review review = this.getReview(e2);
        if (review.getState().isOpenMetaState()) {
            new ReviewDescriptionTextProcessor(review, e2.getActioner(), review.getDescription(), previousDescription, NavBuilder.reviewAbs(null, review), false, "a review's objectives").process();
        }
    }

    @Override
    @EventListener
    public void commentUpdatedEventListener(CommentUpdatedEvent e2) {
        this.comment(this.getComment((ReviewCommentEvent)e2), e2.getActioner(), e2.getOldMessage(), e2.isWasDraft());
    }

    @Override
    @EventListener
    public void reviewDescriptionUpdatedEventListener(ReviewDescriptionUpdatedEvent e2) {
        this.reviewDescription((ReviewEvent)e2, e2.getOldDescription());
    }

    @Override
    @EventListener
    public void reviewStateChangedEventListener(ReviewStateChangedEvent e2) {
        if ((e2.getOldState() == ReviewData.State.Draft || e2.getOldState() == ReviewData.State.Approval) && e2.getNewState() == ReviewData.State.Review) {
            this.reviewDescription((ReviewEvent)e2, null);
            this.checkAllComments((ReviewEvent)e2);
        }
    }

    private void checkAllComments(final ReviewEvent e2) {
        Review review = this.getReview(e2);
        if (this.isInOpenMetaState(review)) {
            this.commentManager.comments(review).where(DiscussionClauses.not(DiscussionClauses.draft())).visit(new CommentOperator(){

                @Override
                public void operate(Comment comment) {
                    DefaultMentionParserListener.this.comment(comment, e2.getActioner(), null, false);
                }
            });
        }
    }

    private Review getReview(ReviewEvent e2) {
        return this.reviewManager.getReviewByPermaId(e2.getReviewId().getId());
    }

    private Comment getComment(ReviewCommentEvent e2) {
        return this.commentManager.getByPermId((PermId<CommentData>)e2.getCommentId());
    }

    protected void logMentionSent(Review review, FecruUser user, String mentionedUserName, String url) {
        LogManager.logMentionEventSent(review, user, mentionedUserName, url);
    }

    private Collection<String> findPriorMentions(Review review, String url) {
        List<LogItem> logItems = this.getLogItems(review.getId(), Collections.singleton(LogAction.MENTION_SENT.getKey()));
        HashSet<String> priorMentions = new HashSet<String>();
        String prefix = url + ", ";
        for (LogItem l2 : logItems) {
            if (!l2.getEntityString().startsWith(prefix)) continue;
            priorMentions.add(l2.getEntityString().substring(prefix.length()));
        }
        return priorMentions;
    }

    protected List<LogItem> getLogItems(int reviewId, Set<String> actions) {
        return LogManager.getLogForReview(reviewId, actions);
    }

    protected final Set<String> parseMentions(String text) {
        HashSet<String> userNames = new HashSet<String>();
        if (text != null) {
            this.findUserNames(AT_MENTION_REGEX, userNames, text);
            this.findUserNames(TILDE_MENTION_REGEX, userNames, text);
        }
        return userNames;
    }

    private void findUserNames(Pattern regex, Set<String> names, String text) {
        Matcher m2 = regex.matcher(text);
        int start = 0;
        while (m2.find(start)) {
            names.add(m2.group(1));
            start = m2.end();
        }
    }

    private boolean isInOpenMetaState(Review review) {
        return review.getState().isOpenMetaState();
    }

    private class ChangesetCommentTextProcessor
    extends TextProcessor {
        private String description;
        private final PermId<CsCommentData> comment;
        private final String csId;
        private final String repoName;

        private ChangesetCommentTextProcessor(UserData actioner, String message, String oldMessage, String url, PermId<CsCommentData> comment, String csId, String repoName) {
            super(actioner, message, oldMessage, url);
            this.comment = comment;
            this.csId = csId;
            this.repoName = repoName;
        }

        @Override
        protected UserMentionedEvent createEvent(String name) {
            return new UserMentionedInChangesetCommentEventImpl(name, this.actioner == null ? null : this.actioner, this.url, this.comment, this.csId, this.repoName);
        }

        @Override
        protected Collection<String> findMentionsToExclude() {
            return Collections.emptySet();
        }
    }

    private class ReviewDescriptionTextProcessor
    extends ReviewTextProcessor {
        private ReviewDescriptionTextProcessor(Review review, UserData actioner, String message, String oldMessage, String url, boolean wasDraft, String description) {
            super(review, actioner, message, oldMessage, url, wasDraft, description);
        }

        @Override
        protected UserMentionedEvent createEvent(String name) {
            return new UserMentionedInReviewDescriptionEventImpl(name, this.actioner, this.url, (PermId<ReviewData>)new PermId(this.review.getPermaId()));
        }
    }

    private class ReviewCommentTextProcessor
    extends ReviewTextProcessor {
        private final PermId<CommentData> comment;

        private ReviewCommentTextProcessor(Review review, PermId<CommentData> comment, UserData actioner, String message, String oldMessage, String url, boolean wasDraft) {
            super(review, actioner, message, oldMessage, url, wasDraft, "a review comment");
            this.comment = comment;
        }

        @Override
        protected UserMentionedEvent createEvent(String name) {
            return new UserMentionedInReviewCommentEventImpl(name, this.actioner, this.url, (PermId<ReviewData>)new PermId(this.review.getPermaId()), this.comment);
        }

        @Override
        protected boolean allowMention(String name) {
            return super.allowMention(name) && !this.doesUserReceiveCommentNotifications(this.review, name);
        }

        private boolean doesUserReceiveCommentNotifications(Review review, String name) {
            FecruUser user = DefaultMentionParserListener.this.userManager.getLicensedUser(name);
            if (user != null) {
                boolean isParticipant;
                boolean bl = isParticipant = review.isAuthor(user) || review.isModerator(user) || review.isReviewer(user);
                if (isParticipant && user.getUserProfile().getCommentEmailNotification() != DeliverySchedule.DISABLE.intValue()) {
                    return true;
                }
            }
            return false;
        }
    }

    private abstract class ReviewTextProcessor
    extends TextProcessor {
        protected final Review review;
        protected final String description;

        private ReviewTextProcessor(Review review, UserData actioner, String message, String oldMessage, String url, boolean wasDraft, String description) {
            super(actioner, message, wasDraft ? "" : oldMessage, url);
            this.review = review;
            this.description = description;
        }

        @Override
        public void process() {
            if (DefaultMentionParserListener.this.isInOpenMetaState(this.review)) {
                super.process();
            }
        }

        @Override
        protected Collection<String> findMentionsToExclude() {
            return DefaultMentionParserListener.this.findPriorMentions(this.review, this.url);
        }

        @Override
        protected void published(String name) {
            DefaultMentionParserListener.this.logMentionSent(this.review, DefaultMentionParserListener.this.userManager.getLicensedUser(this.actioner.getUserName()), name, this.url);
        }
    }

    private abstract class TextProcessor {
        protected final UserData actioner;
        protected final String message;
        protected final String oldMessage;
        protected final String url;

        public TextProcessor(UserData actioner, String message, String oldMessage, String url) {
            this.actioner = actioner;
            this.message = message;
            this.oldMessage = oldMessage;
            this.url = url;
        }

        public void process() {
            Set<String> mentionedUserNames = DefaultMentionParserListener.this.parseMentions(this.message);
            Set<String> previouslyMentionedNames = DefaultMentionParserListener.this.parseMentions(this.oldMessage);
            previouslyMentionedNames.addAll(this.findMentionsToExclude());
            mentionedUserNames.removeAll(previouslyMentionedNames);
            for (String name : mentionedUserNames) {
                if (!this.allowMention(name)) continue;
                DefaultMentionParserListener.this.eventPublisher.publish((Object)this.createEvent(name));
                this.published(name);
            }
        }

        protected boolean allowMention(String name) {
            return true;
        }

        protected void published(String name) {
        }

        protected abstract UserMentionedEvent createEvent(String var1);

        protected abstract Collection<String> findMentionsToExclude();
    }
}

