/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.license;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.license.LicenseChangedEvent;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultLicenseManager
implements LicenseManager {
    private final EventPublisher eventPublisher;
    private final RootConfig rootConfig;
    private final GlobalPermissionManager globalPermissionManager;
    private final Object licensesLock = new Object();

    @Autowired
    public DefaultLicenseManager(RootConfig rootConfig, EventPublisher eventPublisher, GlobalPermissionManager globalPermissionManager) {
        this.rootConfig = rootConfig;
        this.globalPermissionManager = globalPermissionManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public int getFishEyeUsersCount() throws DbException {
        return this.globalPermissionManager.countUsersWithPermission(GlobalPermissionType.FISHEYE_USER);
    }

    @Override
    public int getLicensedUsersCount() throws DbException {
        return this.globalPermissionManager.countUsersWithPermission(LicenseManager.getLicensedGlobalPermissionType());
    }

    @Override
    public int getCrucibleUsersCount() throws DbException {
        return this.globalPermissionManager.countUsersWithPermission(GlobalPermissionType.CRUCIBLE_USER);
    }

    @Override
    public int getExcessFEUsers() {
        int excess = 0;
        LicenseInfo license = this.getLicenseInfo();
        if (this.isLimitedFisheyeLicense(license)) {
            int maximumNumberOfUsers = license.getFisheyeLicense().getMaximumNumberOfUsers();
            excess = this.getFishEyeUsersCount() - maximumNumberOfUsers;
        }
        return excess;
    }

    @Override
    public int getExcessCruUsers() {
        int excess = 0;
        LicenseInfo license = this.getLicenseInfo();
        if (this.isLimitedCrucibleLicense(license)) {
            int maximumNumberOfUsers = license.getCrucibleLicense().getMaximumNumberOfUsers();
            excess = this.getCrucibleUsersCount() - maximumNumberOfUsers;
        }
        return excess;
    }

    private boolean isLimitedFisheyeLicense(LicenseInfo license) {
        return license != null && license.isFishEye() && !license.getFisheyeLicense().isUnlimitedNumberOfUsers();
    }

    private boolean isLimitedCrucibleLicense(LicenseInfo license) {
        return license != null && license.isCrucible() && !license.getCrucibleLicense().isUnlimitedNumberOfUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLicenses(String feLicenseString, String cruLicenseString) throws IOException {
        Object object = this.licensesLock;
        synchronized (object) {
            LicenseInfo oldLicenseInfo = this.getLicenseInfo();
            boolean licensesUpdated = this.saveLicenses(feLicenseString, cruLicenseString);
            if (licensesUpdated) {
                this.rootConfig.saveConfig();
                this.rootConfig.refreshLicenses();
                LicenseInfo newLicenseInfo = this.getLicenseInfo();
                this.eventPublisher.publish((Object)LicenseChangedEvent.create(oldLicenseInfo, newLicenseInfo));
            }
        }
    }

    @Override
    public ProductLicense decodeLicense(String licenseString) throws LicenseException {
        LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense(licenseString, licenseString);
        if (licenseHolder.getFishEyeLicense() != null) {
            return licenseHolder.getFishEyeLicense();
        }
        if (licenseHolder.getCrucibleLicense() != null) {
            return licenseHolder.getCrucibleLicense();
        }
        throw new LicenseException("Not a valid Fisheye or Crucible license");
    }

    @Override
    public LicenseInfo getLicenseInfo() {
        return this.rootConfig.getLicense();
    }

    @Override
    public String getServerId() {
        LicenseType license;
        ConfigDocument.Config config;
        RootConfig rootConfig = AppConfig.getsConfig();
        if (rootConfig != null && (config = rootConfig.getConfig()) != null && (license = config.getLicense()) != null) {
            return license.getSID();
        }
        return null;
    }

    private boolean saveLicenses(String feLicense, String cruLicense) {
        boolean feUpdated = this.updateFeLicense(this.normalizeLicense(feLicense));
        boolean cruUpdated = this.updateCruLicense(this.normalizeLicense(cruLicense));
        return feUpdated || cruUpdated;
    }

    private boolean updateFeLicense(String feLicenseString) {
        LicenseType licenses = this.rootConfig.getConfig().getLicense();
        if (this.shouldChangeLicense(licenses.isSetFisheye(), licenses.getFisheye(), feLicenseString)) {
            licenses.setFisheye(feLicenseString);
            return true;
        }
        return false;
    }

    private boolean updateCruLicense(String cruLicenseString) {
        LicenseType licenses = this.rootConfig.getConfig().getLicense();
        if (this.shouldChangeLicense(licenses.isSetCrucible(), licenses.getCrucible(), cruLicenseString)) {
            licenses.setCrucible(cruLicenseString);
            return true;
        }
        return false;
    }

    private boolean shouldChangeLicense(boolean isLicenseAlreadySet, String oldLicense, String newLicenseString) {
        return !isLicenseAlreadySet || this.hasLicenseChanged(oldLicense, newLicenseString);
    }

    private boolean hasLicenseChanged(String oldLicense, String licenseString) {
        return !Objects.equal((Object)oldLicense, (Object)licenseString);
    }

    private String normalizeLicense(String license) {
        return Strings.isNullOrEmpty((String)license) ? "Disabled" : license;
    }
}

