/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.license;

import com.atlassian.fecru.license.LicenseManager;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.web.filters.MessageSource;
import com.cenqua.fisheye.web.filters.SimpleMessage;
import com.cenqua.fisheye.web.filters.SystemMessage;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AvailableLicensedUsersExceededMessageSource
implements MessageSource {
    static final String HELP_PATH = "fisheye.license.exceeded";
    private final LicenseManager licenseManager;

    @Autowired
    public AvailableLicensedUsersExceededMessageSource(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public List<SystemMessage> getMessages(HttpServletRequest request) {
        boolean isCrucibleLimitsExceeded;
        boolean isFishEyeLimitsExceeded = this.licenseManager.getExcessFEUsers() > 0;
        boolean bl = isCrucibleLimitsExceeded = this.licenseManager.getExcessCruUsers() > 0;
        if (isFishEyeLimitsExceeded || isCrucibleLimitsExceeded) {
            String exceededForProduct = isFishEyeLimitsExceeded ? "FishEye" : "Crucible";
            return Collections.singletonList(new SimpleMessage(String.format("You have exceeded the maximum number of users for %s.", exceededForProduct), HelpUtil.getFishEyeHelpPath(HELP_PATH), true, SimpleMessage.ShowIn.HEADER));
        }
        return Collections.emptyList();
    }
}

