/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.jira.devsummary;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public class ReviewDevDetails {
    private final List<ReviewDetails> reviews;

    public static Reviewer newIncompleteReviewer(DevDetailsUser user) {
        return new Reviewer(user.getName(), false);
    }

    public static Reviewer newCompleteReviewer(DevDetailsUser user) {
        return new Reviewer(user.getName(), true);
    }

    public ReviewDevDetails(List<ReviewDetails> reviews) {
        this.reviews = reviews;
    }

    public List<ReviewDetails> getReviews() {
        return this.reviews;
    }

    public static class DevDetailsUser {
        private final String name;

        public DevDetailsUser(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static class UsernameToUserFunction
        implements Function<String, DevDetailsUser> {
            public DevDetailsUser apply(@Nullable String username) {
                if (Strings.emptyToNull((String)username) == null) {
                    return null;
                }
                return new DevDetailsUser(username);
            }
        }
    }

    public static class Reviewer
    extends DevDetailsUser {
        private final boolean complete;

        public Reviewer(String name, boolean complete) {
            super(name);
            this.complete = complete;
        }

        public boolean isComplete() {
            return this.complete;
        }
    }

    public static class ReviewDetails {
        private final String id;
        private final String state;
        private final String title;
        private final Date dueDate;
        private final Date lastModified;
        private final int commentCount;
        private final DevDetailsUser author;
        private final DevDetailsUser moderator;
        private final List<Reviewer> reviewers;

        public ReviewDetails(String id, String state, String title, Date dueDate, Date lastModified, int commentCount, DevDetailsUser author, DevDetailsUser moderator, List<Reviewer> reviewers) {
            this.state = state;
            this.dueDate = dueDate;
            this.title = title;
            this.id = id;
            this.lastModified = lastModified;
            this.commentCount = commentCount;
            this.author = author;
            this.moderator = moderator;
            this.reviewers = reviewers;
        }

        public int getCommentCount() {
            return this.commentCount;
        }

        public DevDetailsUser getAuthor() {
            return this.author;
        }

        public DevDetailsUser getModerator() {
            return this.moderator;
        }

        public List<Reviewer> getReviewers() {
            return this.reviewers;
        }

        public String getId() {
            return this.id;
        }

        public String getState() {
            return this.state;
        }

        public String getTitle() {
            return this.title;
        }

        public Date getDueDate() {
            return this.dueDate;
        }

        public Date getLastModified() {
            return this.lastModified;
        }
    }
}

