/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.jira;

import com.atlassian.integration.jira.applinks.LinkableEntityResolver;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.config.RepositoryManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class FeCruEntityResolver
implements LinkableEntityResolver {
    public final String PROJECT_PREFIX = "project.";
    public final String REPOSITORY_PREFIX = "repository.";
    private final ProjectManager projectManager;
    private final RepositoryManager repositoryManager;

    @Autowired
    public FeCruEntityResolver(ProjectManager projectManager, RepositoryManager repositoryManager) {
        this.projectManager = projectManager;
        this.repositoryManager = repositoryManager;
    }

    @Nullable
    public Object resolve(@Nonnull String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith("project.")) {
            return this.projectManager.getProjectByKey(key.substring("project.".length()));
        }
        if (key.startsWith("repository.")) {
            return this.repositoryManager.getRepository(key.substring("repository.".length()));
        }
        return null;
    }
}

