/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.iterators;

import com.atlassian.fecru.iterators.PrefetchIteratorValueProvider;
import com.atlassian.fecru.iterators.SkippableIterator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class PrefetchIterator<K, V>
implements SkippableIterator<V> {
    private final LinkedList<K> keys;
    private final PrefetchIteratorValueProvider<K, V> valueProvider;
    private final int prefetchSize;
    private LinkedList<V> cache = new LinkedList();

    public PrefetchIterator(Collection<K> keys, PrefetchIteratorValueProvider<K, V> valueProvider, int prefetchSize) {
        this.keys = new LinkedList<K>(keys);
        this.valueProvider = valueProvider;
        this.prefetchSize = prefetchSize;
    }

    @Override
    public boolean hasNext() {
        this.conditionallyPrefetch();
        return !this.cache.isEmpty();
    }

    @Override
    public int skip(int n2) {
        int n1 = n2;
        int skipCountCache = PrefetchIterator.skip(this.cache, n1);
        int n22 = n2 - skipCountCache;
        int skipCountIds = PrefetchIterator.skip(this.keys, n22);
        return skipCountCache + skipCountIds;
    }

    private static int skip(LinkedList<?> list, int n2) {
        int skipCount;
        if (n2 <= 0) {
            return 0;
        }
        if (list.isEmpty()) {
            return 0;
        }
        for (skipCount = 0; !list.isEmpty() && skipCount < n2; ++skipCount) {
            list.removeFirst();
        }
        return skipCount;
    }

    @Override
    public V next() {
        this.conditionallyPrefetch();
        return this.cache.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void conditionallyPrefetch() {
        if (this.cache.isEmpty() && !this.keys.isEmpty()) {
            this.prefetch();
        }
    }

    private void prefetch() {
        List selectedKeys = this.keys.subList(0, Math.min(this.prefetchSize, this.keys.size()));
        this.cache = new LinkedList<V>(this.valueProvider.values(selectedKeys));
        selectedKeys.clear();
    }
}

