/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.snippet.server;

import com.atlassian.fecru.gwt.comments.shared.CommentGO;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.comments.util.UserModelFactory;
import com.atlassian.fecru.gwt.core.shared.UserMessageException;
import com.atlassian.fecru.gwt.snippet.client.SnippetRPCService;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentGO;
import com.atlassian.fecru.gwt.snippet.shared.FRXGO;
import com.atlassian.fecru.gwt.snippet.shared.InitialLoadAction;
import com.atlassian.fecru.gwt.snippet.shared.InlineCommentModel;
import com.atlassian.fecru.gwt.snippet.shared.ReviewGO;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.InlineCommentRevisionDetail;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.InlineCommentManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.LineRangeUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.diff.DiffHelper;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.view.DiffExplorer;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.util.SyntaxHighlightFormatter;
import com.cenqua.fisheye.web.util.WikiMarkupFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.hibernate.exception.GenericJDBCException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="SnippetRPCService")
public class SnippetRPCServiceImpl
implements SnippetRPCService {
    private final TxTemplate tx;
    private final ReviewManager reviewManager;
    private final CommentManager commentManager;
    private final TxHelper txHelper;
    private final WikiMarkupFormatter wiki;
    @Resource
    private ContentManager contentManager;
    @Resource
    private SourceFactory sourceFactory;

    @Autowired
    public SnippetRPCServiceImpl(TxTemplate tx, ReviewManager reviewManager, CommentManager commentManager) {
        this.tx = tx;
        this.reviewManager = reviewManager;
        this.commentManager = commentManager;
        this.txHelper = new TxHelper();
        this.wiki = new WikiMarkupFormatter();
    }

    protected void beginTx() {
        this.txHelper.beginTx();
    }

    protected void commitTx() {
        try {
            this.txHelper.commitTx();
        }
        catch (GenericJDBCException e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
            throw e2;
        }
    }

    protected void rollbackTxIfNotCommited() {
        this.txHelper.rollbackTxIfNotCommitted();
    }

    private void tryToJoin(Review review) {
        if (this.getCurrentUser() == null) {
            return;
        }
        Set<FecruUser> reviewers = review.getParticipantsAsUsers();
        if (!reviewers.contains(this.getCurrentUser())) {
            this.reviewManager.addReviewer(review, this.getCurrentUser());
            LogManager.logReviewReviewerAdd(review, this.getCurrentUser(), this.getCurrentUser(), review.getState().isReviewState());
            review.setReviewerComplete(this.getCurrentUser());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InlineCommentModel editInlineReplyComment(String permaId, InlineCommentModel commentModel) throws UserMessageException {
        Review review = this.reviewManager.getReviewByPermaId(permaId);
        this.checkCommentPermission(review);
        try {
            this.beginTx();
            Comment comment = this.commentManager.getById(commentModel.getId());
            boolean wasDraft = comment.isDraft();
            this.checkCommentAuthor(comment, "edit");
            String oldText = comment.getMessage();
            if (!commentModel.isDraft()) {
                if (wasDraft) {
                    LogManager.logCommentAdded(review, comment);
                } else {
                    LogManager.logCommentChanged(review, comment, commentModel.getText());
                }
            }
            this.copyCommentAttributes(commentModel, comment);
            this.commentManager.announceCommentUpdate(comment, oldText, wasDraft);
            this.commitTx();
            InlineCommentModel inlineCommentModel = this.createInlineCommentModel(comment, -1, new int[0]);
            return inlineCommentModel;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    @Override
    public InlineCommentModel createInlineComment(String permaId, InlineCommentModel commentModel) throws UserMessageException {
        Review review = this.reviewManager.getReviewByPermaId(permaId);
        try {
            this.beginTx();
            this.tryToJoin(review);
            this.checkCommentPermission(review);
            Comment comment = this.commentManager.createComment(commentModel.getText(), review, this.getCurrentUser());
            this.copyCommentAttributes(commentModel, comment);
            FileRevisionExtraInfo frx = FRXManager.getById(commentModel.getFrxId());
            FRXRevision frxRev = frx.getFileFRXRevision();
            HashMap<FRXRevision, String> revisionLineRanges = new HashMap<FRXRevision, String>();
            TreeSet<Integer> sortedLines = new TreeSet<Integer>();
            for (int line : commentModel.getLines()) {
                sortedLines.add(line);
            }
            revisionLineRanges.put(frxRev, LineRangeUtil.generateLineRange(sortedLines));
            InlineCommentManager.createInlineComment(frx, comment, revisionLineRanges);
            if (!comment.isDraft()) {
                LogManager.logCommentAdded(review, comment);
            }
            this.commentManager.announceCommentCreation(comment);
            this.commitTx();
            InlineCommentModel inlineCommentModel = this.createInlineCommentModel(comment, frx.getId(), commentModel.getLines());
            return inlineCommentModel;
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.error((Object)"Error creating inline comment", (Throwable)e2);
            throw e2;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InlineCommentModel editInlineComment(String permaId, InlineCommentModel commentModel) throws UserMessageException {
        Review review = this.reviewManager.getReviewByPermaId(permaId);
        this.checkCommentPermission(review);
        try {
            this.beginTx();
            Comment comment = this.commentManager.getById(commentModel.getId());
            boolean wasDraft = comment.isDraft();
            this.checkCommentAuthor(comment, "edit");
            String oldText = comment.getMessage();
            TreeSet<Integer> sortedLines = new TreeSet<Integer>();
            for (int line : commentModel.getLines()) {
                sortedLines.add(line);
            }
            if (!commentModel.isDraft()) {
                if (wasDraft) {
                    LogManager.logCommentAdded(review, comment);
                } else {
                    LogManager.logCommentChanged(review, comment, commentModel.getText());
                }
            }
            comment.setMessage(commentModel.getText());
            InlineComment inlineComment = InlineCommentManager.getInlineCommentById(commentModel.getId());
            inlineComment.getDetails().iterator().next().setLineRange(LineRangeUtil.generateLineRange(sortedLines));
            this.copyCommentAttributes(commentModel, inlineComment.getComment());
            this.commentManager.announceCommentUpdate(comment, oldText, wasDraft);
            this.commitTx();
            InlineCommentModel inlineCommentModel = this.createInlineCommentModel(comment, inlineComment.getFrx().getId(), commentModel.getLines());
            return inlineCommentModel;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private void copyCommentAttributes(CommentModel model, Comment comment) {
        comment.setMessage(model.getText());
        comment.setDefectRaised(model.isDefect());
        comment.setDraft(model.isDraft());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteComment(String permaId, int commentId) throws UserMessageException {
        Review review = this.reviewManager.getReviewByPermaId(permaId);
        this.checkCommentPermission(review);
        try {
            this.beginTx();
            Comment comment = this.commentManager.getById(commentId);
            this.checkCommentAuthor(comment, "delete");
            this.commentManager.deleteComment(comment);
            this.commitTx();
            Boolean bl = true;
            return bl;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InlineCommentModel createInlineReplyComment(String permaId, int parentId, InlineCommentModel commentModel) throws UserMessageException {
        Review review = this.reviewManager.getReviewByPermaId(permaId);
        try {
            this.beginTx();
            this.tryToJoin(review);
            this.checkCommentPermission(review);
            Comment parent = this.commentManager.getById(parentId);
            if (parent == null) {
                throw new RuntimeException("Can't find the comment you are replying to, it may have been deleted. (" + parentId + ")");
            }
            if (!parent.isDraft() && !parent.isVisibleToAll()) {
                throw new RuntimeException("Can't post replies to drafts.");
            }
            if (parent.isDeleted()) {
                throw new RuntimeException("Sorry, this comment (" + parentId + ") has been deleted. (Please reload the page for updates)");
            }
            Comment comment = this.commentManager.createComment(commentModel.getText(), review, this.getCurrentUser());
            comment.setDraft(commentModel.isDraft());
            parent.addComment(comment);
            if (!comment.isDraft()) {
                LogManager.logCommentAdded(review, comment);
            }
            this.commentManager.announceCommentCreation(comment);
            this.commitTx();
            InlineCommentModel inlineCommentModel = this.createInlineCommentModel(comment, -1, new int[0]);
            return inlineCommentModel;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private InlineCommentModel createInlineCommentModel(Comment comment, int frxId, int[] lines) {
        return new InlineCommentModel(comment.getId(), comment.getMessage(), this.wiki.formatText(comment.getMessage(), comment.getReview()), UserModelFactory.fromUser(comment.getUser()), comment.getCreateDate(), true, true, comment.isDefectRaised(), comment.isDraft(), frxId, lines);
    }

    private CommentGO createCommentGO(Integer parentId, Comment comment, Map<Integer, CommentGO> replies, boolean editable, boolean commentable) {
        return new CommentGO(parentId, comment.getId(), comment.getMessage(), this.wiki.formatText(comment.getMessage(), comment.getReview()), UserModelFactory.fromUser(comment.getUser()), comment.getCreateDate(), replies, editable, commentable, comment.isDefectRaised(), comment.isDraft());
    }

    private InlineCommentGO createInlineCommentGO(InlineCommentRevisionDetail icrd, boolean editable, boolean commentable) {
        InlineComment ic = icrd.getInlineComment();
        Comment comment = ic.getComment();
        SortedSet<Integer> linesSet = icrd.getIndividualLines();
        int[] lines = new int[linesSet.size()];
        int j2 = 0;
        for (Integer line : linesSet) {
            lines[j2] = line;
            ++j2;
        }
        int parentId = comment.getReplyToComment() == null ? -1 : comment.getReplyToComment().getId();
        return new InlineCommentGO(parentId, comment.getId(), ic.getFrx().getId(), comment.getMessage(), this.wiki.formatText(comment.getMessage(), comment.getReview()), lines, UserModelFactory.fromUser(comment.getUser()), comment.getCreateDate(), this.getReplies(comment), editable, commentable, comment.isDefectRaised(), comment.isDraft());
    }

    private Map<Integer, CommentGO> getReplies(Comment parent) {
        HashMap<Integer, CommentGO> replies = new HashMap<Integer, CommentGO>();
        for (Comment comment : parent.getComments()) {
            if (!comment.isVisible(this.getCurrentUser())) continue;
            Map<Integer, CommentGO> subReplies = this.getReplies(comment);
            boolean isOpen = comment.getReview().getState().isOpenMetaState();
            boolean editable = isOpen && comment.getUser().equals(this.getCurrentUser());
            boolean commentable = isOpen && this.getCurrentUser() != null;
            replies.put(comment.getId(), this.createCommentGO(parent.getId(), comment, subReplies, editable, commentable));
        }
        return replies;
    }

    @Override
    public InitialLoadAction initialLoad(String permaid, boolean isPrint) {
        Review review;
        try {
            review = this.reviewManager.getReviewByPermaId(permaid);
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"Exception getting review", (Throwable)e2);
            throw new RuntimeException(e2);
        }
        this.checkViewPermission(review);
        boolean isEditable = !isPrint && review.getState().isOpenMetaState();
        Set<Comment> comments = review.getComments();
        HashMap<Integer, CommentGO> commentGOs = new HashMap<Integer, CommentGO>();
        for (Comment comment : comments) {
            if (!comment.isVisible(this.getCurrentUser())) continue;
            boolean editable = isEditable && comment.getUser().equals(this.getCurrentUser());
            boolean commentable = isEditable && this.getCurrentUser() != null;
            commentGOs.put(comment.getId(), this.createCommentGO(-1, comment, this.getReplies(comment), editable, commentable));
        }
        ReviewGO rdo = new ReviewGO();
        rdo.setId(review.getId());
        rdo.setPermaid(review.getPermaId());
        rdo.setName(review.getName());
        rdo.setDescription(review.getDescription());
        rdo.setReviewComments(commentGOs);
        rdo.setCommentable(isEditable && this.getCurrentUser() != null);
        rdo.setAuthor(UserModelFactory.fromUser(review.getAuthor()));
        rdo.setCreateDate(review.getCreateDateTime());
        Set<FileRevisionExtraInfo> frxs = review.getFrxs();
        if (frxs.isEmpty()) {
            Logs.APP_LOG.warn((Object)("Trying to view a snippet review (" + review.getId() + ") with 0 files"));
            return new InitialLoadAction(rdo, new String[0]);
        }
        if (frxs.size() != 1) {
            Logs.APP_LOG.warn((Object)("Trying to view a snippet review (" + review.getId() + ") with more than 1 file. Only including first one."));
        }
        FileRevisionExtraInfo frx = frxs.iterator().next();
        FRXGO fdo = new FRXGO();
        fdo.setId(frx.getId());
        if (frx.getFrxRevisions().isEmpty()) {
            Logs.APP_LOG.warn((Object)("Trying to view a snippet file (" + frx.getId() + ") with 0 revisions"));
            return new InitialLoadAction(rdo, new String[0]);
        }
        if (frx.getFrxRevisions().size() != 1) {
            Logs.APP_LOG.warn((Object)("Trying to view a snippet file (" + frx.getId() + ") with more than 1 revision. Only including latest one."));
        }
        FRXRevision frxRevision = frx.getFrxRevisions().get(frx.getFrxRevisions().size() - 1);
        CrucibleRevision revision = frxRevision.getRevision();
        Set<InlineComment> inlineComments = frx.getInlineComments();
        HashMap<Integer, InlineCommentGO> inlineCommentGOs = new HashMap<Integer, InlineCommentGO>();
        for (InlineComment comment : inlineComments) {
            if (!comment.isVisible(this.getCurrentUser())) continue;
            InlineCommentRevisionDetail detail = null;
            boolean others = false;
            for (InlineCommentRevisionDetail d2 : comment.getDetails()) {
                if (d2.getFrxRevision().equals(frxRevision)) {
                    detail = d2;
                    continue;
                }
                others = true;
            }
            if (detail == null) {
                Logs.APP_LOG.warn((Object)("Trying to display a comment (" + comment.getId() + ") on not the latest revision. Snippets dont support this."));
                continue;
            }
            if (others) {
                Logs.APP_LOG.warn((Object)("Trying to display a comment (" + comment.getId() + ") across multiple revisions. Only including the latest one."));
            }
            boolean editable = isEditable && comment.getComment().getUser().equals(this.getCurrentUser());
            boolean commentable = isEditable && this.getCurrentUser() != null;
            inlineCommentGOs.put(comment.getId(), this.createInlineCommentGO(detail, editable, commentable));
        }
        fdo.setInlineComments(inlineCommentGOs);
        rdo.setFrx(fdo);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            Source source = this.sourceFactory.getSource(revision.getSourceName(), this.getCurrentPrincipal());
            IndexedLineReader reader = this.getContents(review.getProject(), revision, source);
            DiffExplorer diffExplorer = this.getDiffExplorer(revision, reader, source);
            Iterator<LinePair> linePairIterator = diffExplorer.getPrinter().getLinePairIterator();
            SyntaxHighlightFormatter highlighter = this.getHighlighter(revision.getSnippetSyntax(), reader);
            while (linePairIterator.hasNext()) {
                LinePair linePair = linePairIterator.next();
                highlighter.setStartLine(linePair.getToLineNumberEquiv());
                highlighter.setEndLine(linePair.getToLineNumberEquiv());
                lines.add(highlighter.formatLine(linePair.getToLineNumberEquiv()));
            }
        }
        catch (Exception e3) {
            throw new RuntimeException("Failed to get contents");
        }
        return new InitialLoadAction(rdo, lines.toArray(new String[lines.size()]));
    }

    private SyntaxHighlightFormatter getHighlighter(String synhiName, IndexedLineReader reader) throws IOException {
        SyntaxHighlightFormatter highlighter = new SyntaxHighlightFormatter();
        reader.scanRestOfFile();
        SyntaxDefinitions.ParseResult synhi = AppConfig.getsConfig().getSyntaxDefinitions().getRegionsForFile("." + synhiName, reader.getCharSequence());
        RegionList regions = synhi.getRegions();
        highlighter.setRegions(regions);
        highlighter.setInput(reader);
        return highlighter;
    }

    private void checkViewPermission(Review review) throws RuntimeException {
        if (!ReviewUtil.principalCanDoReviewAction(this.getCurrentPrincipal(), this.getCurrentUser(), UserActionManager.ACTION_VIEW, review)) {
            if (Principal.Anonymous.isAnon((Principal)this.getCurrentPrincipal())) {
                throw new RuntimeException("Login required");
            }
            throw new RuntimeException("Permission denied");
        }
    }

    private void checkCommentPermission(Review review) throws UserMessageException {
        if (!ReviewUtil.principalCanDoReviewAction(this.getCurrentPrincipal(), this.getCurrentUser(), UserActionManager.ACTION_COMMENT, review)) {
            if (Principal.Anonymous.isAnon((Principal)this.getCurrentPrincipal())) {
                throw new UserMessageException("Login required");
            }
            throw new UserMessageException("Permission denied");
        }
        if (review.getState().isClosedMetaState()) {
            throw new UserMessageException("This snippet has been closed for comments");
        }
    }

    private void checkCommentAuthor(Comment comment, String verb) throws UserMessageException {
        if (!comment.getUser().equals(this.getCurrentUser())) {
            throw new UserMessageException("You can't " + verb + " someone else's comment");
        }
    }

    private FecruUser getCurrentUser() {
        return this.tx.getEffectiveCrucibleUser();
    }

    private Principal getCurrentPrincipal() {
        return this.tx.getEffectivePrincipal();
    }

    private IndexedLineReader getContents(Project project, CrucibleRevision fr, Source source) throws Exception {
        Disposer disposer = Disposer.threadInstance();
        return this.contentManager.getContents(source, project, fr, disposer, null);
    }

    private DiffExplorer getDiffExplorer(CrucibleRevision fr, IndexedLineReader reader, Source source) throws Exception {
        String fileName = fr.getFePath().getName();
        String rev = fr.getRevision();
        DiffInfo diffInfo = new DiffInfo(source.getName(), fileName, fr.getPath(), rev, fr.getPath(), rev);
        FileDiffExplorer diffExp = DiffHelper.diffReaders(reader, reader, diffInfo, null);
        diffExp.setContextLines(-1);
        return diffExp;
    }
}

