/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.snippet.client.ui.print;

import com.atlassian.fecru.gwt.comments.client.ui.ViewDisplay;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.snippet.shared.InlineCommentModel;

public class CommentPrintPresenter<T extends CommentModel> {
    private T comment;
    private Display display;

    public CommentPrintPresenter(T comment, Display display) {
        this.comment = comment;
        this.display = display;
        this.bindDisplay();
    }

    private void bindDisplay() {
        this.display.showDisplay(true);
        this.display.getBody().setHTML(((CommentModel)this.comment).getText());
        this.display.setAvatarImageUrl(((CommentModel)this.comment).getAuthor().getAvatarUrl());
        this.display.setAvatarLinkHref(((CommentModel)this.comment).getAuthor().getUrl());
        this.display.setAuthorHeadingLinkHref(((CommentModel)this.comment).getAuthor().getUrl());
        this.display.setAuthorName(((CommentModel)this.comment).getAuthor().getDisplayName());
        this.display.setCreateDate(((CommentModel)this.comment).getCreateDate());
        if (this.comment instanceof InlineCommentModel) {
            InlineCommentModel inlineComment = (InlineCommentModel)this.comment;
            this.display.setLineRange(inlineComment.getLineRangeText());
        }
    }

    public static interface Display
    extends ViewDisplay {
        public void setLineRange(String var1);
    }
}

