/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.snippet.client.ui.comment.segments;

import com.atlassian.fecru.gwt.comments.client.ui.CommentEditDisplay;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentContainer;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.PositionsComments;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.segments.CommentContainerSegment;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.segments.Segment;
import com.atlassian.fecru.gwt.snippet.client.ui.widget.ListWidget;
import com.atlassian.fecru.gwt.snippet.shared.InlineCommentModel;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InlineCommentPositionController
implements PositionsComments<InlineCommentContainer> {
    private final ListWidget linesList;
    private final Map<Integer, Segment> containerIdMap;
    private final List<CommentContainerSegment<InlineCommentContainer>> segmentObjects;
    private List<CommentContainerSegment<InlineCommentContainer>> sortedSegmentObjects;
    private JavaScriptObject canvas = null;
    private int lastCommentBottom = 0;
    private int canvasMinHeight = 0;
    private int baseOffsetPx = 16;

    public InlineCommentPositionController(ListWidget linesList, int baseOffsetPx) {
        this.linesList = linesList;
        this.containerIdMap = new HashMap<Integer, Segment>();
        this.segmentObjects = new ArrayList<CommentContainerSegment<InlineCommentContainer>>();
        this.baseOffsetPx = baseOffsetPx;
    }

    @Override
    public void registerContainer(InlineCommentContainer container) {
        CommentContainerSegment<InlineCommentContainer> segment = new CommentContainerSegment<InlineCommentContainer>(container);
        this.segmentObjects.add(segment);
        this.containerIdMap.put(((InlineCommentModel)container.getCommentModel()).getId(), segment);
        this.invalidateSortedCache();
    }

    @Override
    public void unregisterContainerById(int id) {
        Segment segment = this.containerIdMap.get(id);
        if (segment != null) {
            if (segment instanceof CommentContainerSegment) {
                this.segmentObjects.remove((CommentContainerSegment)segment);
            }
            this.containerIdMap.remove(id);
            segment.removePath();
            this.invalidateSortedCache();
        }
    }

    private void invalidateSortedCache() {
        this.sortedSegmentObjects = null;
    }

    private List<CommentContainerSegment<InlineCommentContainer>> getSortedSegments() {
        if (this.sortedSegmentObjects == null) {
            this.sortedSegmentObjects = new ArrayList<CommentContainerSegment<InlineCommentContainer>>();
            this.sortedSegmentObjects.addAll(this.segmentObjects);
            Collections.sort(this.sortedSegmentObjects, new Comparator<CommentContainerSegment<InlineCommentContainer>>(){

                @Override
                public int compare(CommentContainerSegment<InlineCommentContainer> left, CommentContainerSegment<InlineCommentContainer> right) {
                    InlineCommentModel leftModel = (InlineCommentModel)left.getContainer().getCommentModel();
                    InlineCommentModel rightModel = (InlineCommentModel)right.getContainer().getCommentModel();
                    int lineCompare = leftModel.getLowestLine() - rightModel.getLowestLine();
                    if (lineCompare != 0) {
                        return lineCompare;
                    }
                    return leftModel.getCreateDate().compareTo(rightModel.getCreateDate());
                }
            });
        }
        return this.sortedSegmentObjects;
    }

    @Override
    public void repositionComments() {
        int lastCommentBottom = 0;
        int PADDING = 5;
        for (CommentContainerSegment<InlineCommentContainer> containerSegment : this.getSortedSegments()) {
            InlineCommentContainer container = containerSegment.getContainer();
            LIElement li = container.getLiElement();
            Element element = container.getContainer().getElement();
            int offsetTop = li.getOffsetTop();
            if (lastCommentBottom > offsetTop) {
                offsetTop = lastCommentBottom + PADDING;
            }
            element.getStyle().setPosition(Style.Position.ABSOLUTE);
            element.getStyle().setTop((double)offsetTop, Style.Unit.PX);
            if (containerSegment.hasPath()) {
                containerSegment.removePath();
            }
            JavaScriptObject canvas = this.getCanvas();
            JsArray<JavaScriptObject> path = this.createSegmentPath(li, canvas, false, offsetTop);
            containerSegment.drawPath((JavaScriptObject)path, canvas, this.getCommentStyle());
            lastCommentBottom = element.getOffsetTop() + element.getOffsetHeight() + PADDING;
        }
        this.lastCommentBottom = lastCommentBottom;
        this.ensureSourceHeight();
    }

    private void ensureSourceHeight() {
        Element listElement = this.linesList.getElement();
        int listBottom = listElement.getOffsetTop() + listElement.getOffsetHeight();
        if (listBottom < this.lastCommentBottom + this.baseOffsetPx) {
            int height = this.lastCommentBottom + this.baseOffsetPx - listElement.getOffsetTop();
            listElement.getParentElement().getStyle().setHeight((double)height, Style.Unit.PX);
            this.setCanvasHeight(this.canvas, this.canvasMinHeight);
        }
    }

    @Override
    public void positionNewCommentForm(CommentEditDisplay ced, LIElement li) {
        int elementTop = li.getOffsetTop();
        Element element = ced.getElement();
        element.getStyle().setPosition(Style.Position.ABSOLUTE);
        element.getStyle().setZIndex(5);
        element.getStyle().setTop((double)elementTop, Style.Unit.PX);
        Segment s2 = this.containerIdMap.get(NEW_CONTAINER_ID);
        if (s2 == null) {
            s2 = new Segment();
            this.containerIdMap.put(NEW_CONTAINER_ID, s2);
        } else {
            s2.removePath();
        }
        JavaScriptObject canvas = this.getCanvas();
        JsArray<JavaScriptObject> path = this.createSegmentPath(li, canvas, true);
        s2.drawPath((JavaScriptObject)path, canvas, this.newCommentStyle());
        s2.toFront();
    }

    private JsArray<JavaScriptObject> createSegmentPath(LIElement li, JavaScriptObject canvas, boolean isNew) {
        return this.createSegmentPath(li, canvas, isNew, -1);
    }

    private JsArray<JavaScriptObject> createSegmentPath(LIElement li, JavaScriptObject canvas, boolean isNew, int commentTop) {
        int heightOfOneLine = Math.min(li.getOffsetHeight(), 30);
        int liTop = li.getOffsetTop();
        if (commentTop < 0) {
            commentTop = liTop;
        }
        int width = DOM.getElementById((String)"segment-canvas").getOffsetWidth();
        int x2 = isNew ? width : width - 1;
        JsArray path = (JsArray)JavaScriptObject.createArray();
        path.push(this.makeSvgPath("M", x2, commentTop + 10 + this.baseOffsetPx));
        path.push(this.makeSvgPath("L", 0, liTop + heightOfOneLine / 2));
        path.push(this.makeSvgPath("L", x2, commentTop + 10 + heightOfOneLine + this.baseOffsetPx));
        if (this.canvasMinHeight < commentTop + 10 + heightOfOneLine + this.baseOffsetPx) {
            this.canvasMinHeight = commentTop + 10 + heightOfOneLine + this.baseOffsetPx;
            this.setCanvasHeight(canvas, this.canvasMinHeight);
        }
        return path;
    }

    private JavaScriptObject getCanvas() {
        if (this.canvas == null) {
            this.canvas = this.createCanvas();
            this.canvasMinHeight = 0;
        }
        return this.canvas;
    }

    private native void setCanvasHeight(JavaScriptObject var1, int var2);

    private native JavaScriptObject createCanvas();

    private native JavaScriptObject makeSvgPath(String var1, Integer var2, Integer var3);

    private native JavaScriptObject newCommentStyle();

    private native JavaScriptObject getCommentStyle();
}

