/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.snippet.client.ui.comment;

import com.atlassian.fecru.gwt.comments.client.ui.CommentContainer;
import com.atlassian.fecru.gwt.comments.client.ui.CommentEditDisplay;
import com.atlassian.fecru.gwt.comments.client.ui.CommentEditPresenter;
import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.util.CommentUtil;
import com.atlassian.fecru.gwt.comments.shared.CommentGO;
import com.atlassian.fecru.gwt.snippet.client.BoundSnippetInlineCommentRPCService;
import com.atlassian.fecru.gwt.snippet.client.SnippetRPCServiceAsync;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentContainer;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentEditPresenter;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentGO;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.LineSelector;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.PositionsComments;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.SnippetContainerCreator;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.segments.InlineCommentPositionController;
import com.atlassian.fecru.gwt.snippet.client.ui.events.CreateInlineCommentEvent;
import com.atlassian.fecru.gwt.snippet.client.ui.events.CreateInlineCommentEventHandler;
import com.atlassian.fecru.gwt.snippet.client.ui.print.CommentPrintPositionController;
import com.atlassian.fecru.gwt.snippet.client.ui.widget.OrderedList;
import com.atlassian.fecru.gwt.snippet.shared.InlineCommentModel;
import com.atlassian.fecru.gwt.snippet.shared.ReviewGO;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class InlineCommentController {
    private ReviewGO review;
    private final SnippetContainerCreator<InlineCommentModel> containerCreator;
    private final PositionsComments positionController;
    private SnippetRPCServiceAsync snippetService;
    private Set<Element> selectedLines;
    private boolean selectedLinesLocked;
    private LIElement lastSelectedLine;
    private LIElement firstSelectedLine;
    private boolean selecting;
    private Integer currentCommentEditedId;
    private Map<Integer, LIElement> lineElements;
    private Map<Integer, Set<Integer>> commentLines;
    private HandlerManager eventBus;
    private static final int INLINE_COMMENT_NEW_PARENT_ID = -2;
    private static final String LINE_SELECTED_CLASS = "lineSelected";
    private static final String LINE_HIGHLIGHTED_CLASS = "lineHighlighted";
    private boolean awaitingReposition = false;
    private CommentEditDisplay ced;
    private InlineCommentEditPresenter cep;
    private LineSelector lineSelector = new LineSelector(){

        @Override
        public void selectLines(int[] lines) {
            if (!InlineCommentController.this.selectedLinesLocked) {
                InlineCommentController.this.highlightLines(lines);
            }
        }

        @Override
        public void clearSelected() {
            if (!InlineCommentController.this.selectedLinesLocked) {
                InlineCommentController.this.clearSelectedLines();
            }
        }
    };

    public InlineCommentController(HandlerManager eventBus, ReviewGO review, SnippetContainerCreator<InlineCommentModel> containerCreator, OrderedList linesList, Map<Integer, LIElement> lineElements, SnippetRPCServiceAsync snippetService) {
        this.review = review;
        this.containerCreator = containerCreator;
        this.containerCreator.setLineSelector(this.lineSelector);
        this.selectedLines = new TreeSet<Element>(new Comparator<Element>(){

            @Override
            public int compare(Element left, Element right) {
                return left.getPropertyInt("lineNum") - right.getPropertyInt("lineNum");
            }
        });
        this.lineElements = lineElements;
        this.snippetService = snippetService;
        this.eventBus = eventBus;
        this.positionController = containerCreator.isPrint() ? new CommentPrintPositionController() : new InlineCommentPositionController(linesList, review.isCommentable() ? 16 : 0);
        this.commentLines = new HashMap<Integer, Set<Integer>>();
    }

    private void selectLine(Element element, boolean select) {
        if (element == null) {
            return;
        }
        if (select) {
            this.selectedLines.add(element);
            element.addClassName(LINE_SELECTED_CLASS);
        } else {
            this.selectedLines.remove(element);
            element.removeClassName(LINE_SELECTED_CLASS);
        }
    }

    public void clearSelectedLines() {
        for (Element li : this.selectedLines) {
            li.removeClassName(LINE_HIGHLIGHTED_CLASS);
            li.removeClassName(LINE_SELECTED_CLASS);
        }
        this.selectedLines.clear();
        this.hideCopyToClipboard();
    }

    private void highlightLines(int[] lines) {
        for (int line : lines) {
            LIElement li = this.lineElements.get(line);
            li.addClassName(LINE_HIGHLIGHTED_CLASS);
            this.selectedLines.add((Element)li);
        }
    }

    public void mouseDown(LIElement li) {
        this.clearSelectedLines();
        this.selectLine((Element)li, true);
        this.lastSelectedLine = li;
        this.firstSelectedLine = li;
        this.selecting = true;
    }

    public void mouseUp(MouseUpEvent event) {
        if (!this.selecting) {
            return;
        }
        this.selecting = false;
        int[] lines = new int[this.selectedLines.size()];
        int i2 = 0;
        for (Element li : this.selectedLines) {
            lines[i2++] = li.getPropertyInt("lineNum");
        }
        this.eventBus.fireEvent((GwtEvent)new CreateInlineCommentEvent(lines, this.currentCommentEditedId));
        this.showCopyToClipboard(event);
    }

    private void hideCopyToClipboard() {
        DOM.getElementById((String)"copy-clipboard").getStyle().setLeft(-999.0, Style.Unit.PX);
    }

    private void showCopyToClipboard(MouseUpEvent event) {
        Style clipboardStyle = DOM.getElementById((String)"copy-clipboard").getStyle();
        clipboardStyle.setLeft((double)(event.getX() + event.getRelativeElement().getAbsoluteLeft() + 8), Style.Unit.PX);
        clipboardStyle.setTop((double)(event.getY() + event.getRelativeElement().getAbsoluteTop() + 8), Style.Unit.PX);
        StringBuilder text = new StringBuilder();
        for (Element li : this.selectedLines) {
            text.append(li.getInnerText()).append("\n");
        }
        this.setClipboardText(text.toString());
    }

    private native void setClipboardText(String var1);

    public void mouseMove(LIElement li) {
        Direction direction;
        if (!this.selecting || this.lastSelectedLine == null || li == null || li.equals((Object)this.lastSelectedLine) || li.equals((Object)this.firstSelectedLine)) {
            return;
        }
        Direction direction2 = direction = li.getOffsetTop() > this.lastSelectedLine.getOffsetTop() ? Direction.DOWN : Direction.UP;
        if (this.selectedLines.contains(li)) {
            this.fillSelection(li, direction, false);
            this.selectLine((Element)this.lastSelectedLine, false);
        } else {
            this.fillSelection(li, direction, true);
            this.selectLine((Element)li, true);
        }
        this.lastSelectedLine = li;
    }

    private Element getNextSelectionElement(Element li, Direction direction) {
        boolean isNextElement = true;
        if (direction.equals((Object)Direction.UP)) {
            isNextElement = this.selecting;
        } else if (direction.equals((Object)Direction.DOWN)) {
            isNextElement = !this.selecting;
        }
        Element r2 = isNextElement ? li.getNextSiblingElement() : (Element)li.getPreviousSibling();
        return r2;
    }

    private void fillSelection(LIElement li, Direction direction, boolean shouldSelect) {
        LIElement target;
        LIElement next = shouldSelect ? li : this.getNextSelectionElement((Element)li, direction);
        LIElement lIElement = target = shouldSelect ? this.firstSelectedLine : this.lastSelectedLine;
        while (next != null && !next.equals((Object)target)) {
            this.selectLine((Element)next, shouldSelect);
            next = this.getNextSelectionElement((Element)next, direction);
        }
    }

    public void setupInlineComments() {
        BoundSnippetInlineCommentRPCService rpcService = new BoundSnippetInlineCommentRPCService(this.snippetService, this.review.getPermaid(), this.review.getFrx().getId());
        if (!this.containerCreator.isPrint()) {
            this.bindGlobalHandlers(rpcService);
        }
        ArrayList<InlineCommentGO> commentGOs = new ArrayList<InlineCommentGO>();
        commentGOs.addAll(this.review.getFrx().getInlineComments().values());
        Collections.sort(commentGOs, new Comparator<InlineCommentGO>(){

            @Override
            public int compare(InlineCommentGO left, InlineCommentGO right) {
                int lineCompare = left.getLowestLine() - right.getLowestLine();
                if (lineCompare != 0) {
                    return lineCompare;
                }
                return left.getCreateDate().compareTo(right.getCreateDate());
            }
        });
        for (InlineCommentGO comment : commentGOs) {
            CommentContainer<InlineCommentModel, ?> c2 = this.insertInlineComment(rpcService, comment);
            this.positionController.registerContainer(c2);
        }
    }

    private CommentContainer<InlineCommentModel, ?> insertInlineComment(CommentRPCService<InlineCommentModel> rpcService, InlineCommentGO comment) {
        InlineCommentModel model = new InlineCommentModel(comment.getId(), comment.getText(), comment.getHtml(), comment.getAuthor(), comment.getCreateDate(), comment.isEditable(), comment.isCommentable(), comment.isDefect(), comment.isDraft(), comment.getFrxId(), comment.getLines());
        CommentContainer<InlineCommentModel, ?> container = this.containerCreator.createContainer(-1, comment.getId(), model, rpcService, this.eventBus, new ArrayList<CommentGO>(comment.getReplies().values()));
        this.insertComment(container, this.lineElements.get(comment.getLowestLine()));
        this.updatedCommentedLines(comment.getId(), comment.getLines());
        if (!this.containerCreator.isPrint()) {
            this.bindCommentHandlers(comment.getId(), container);
        }
        return container;
    }

    private void bindGlobalHandlers(final CommentRPCService<InlineCommentModel> rpcService) {
        this.eventBus.addHandler(CreateInlineCommentEvent.TYPE, (EventHandler)new CreateInlineCommentEventHandler(){

            @Override
            public void onCreateInlineCommentEvent(final CreateInlineCommentEvent event) {
                InlineCommentController.this.selectedLinesLocked = true;
                if (InlineCommentController.this.currentCommentEditedId == null && InlineCommentController.this.cep == null) {
                    DeferredCommand.addCommand((Command)new Command(){

                        public void execute() {
                            InlineCommentController.this.ced = new CommentEditDisplay();
                            InlineCommentModel model = new InlineCommentModel(-2, "", "", null, new Date(), true, true, false, false, InlineCommentController.this.review.getFrx().getId(), event.getLines());
                            InlineCommentController.this.cep = new InlineCommentEditPresenter(rpcService, InlineCommentController.this.eventBus, (CommentEditPresenter.Display)InlineCommentController.this.ced, (Integer)-2, null, model);
                            InlineCommentController.this.insertComment((Widget)InlineCommentController.this.ced);
                            InlineCommentController.this.positionController.positionNewCommentForm(InlineCommentController.this.ced, (LIElement)InlineCommentController.this.lineElements.get(event.getLowestLine()));
                            InlineCommentController.this.eventBus.fireEvent(new EditCommentEvent<InlineCommentModel>(-2, null, model, null, false));
                        }
                    });
                } else if (InlineCommentController.this.cep != null && event.getLines().length == 0) {
                    InlineCommentController.this.positionController.unregisterContainerById(InlineCommentPositionController.NEW_CONTAINER_ID);
                    InlineCommentController.this.cep.destroy();
                    InlineCommentController.this.cep = null;
                } else if (InlineCommentController.this.cep != null) {
                    InlineCommentController.this.positionController.positionNewCommentForm(InlineCommentController.this.ced, (LIElement)InlineCommentController.this.lineElements.get(event.getLowestLine()));
                }
            }
        });
        this.eventBus.addHandler(EditCommentEvent.TYPE, (EventHandler)new EditCommentEventHandler(){

            public void onEditCommentEvent(EditCommentEvent editCommentEvent) {
                InlineCommentController.this.selectedLinesLocked = true;
                InlineCommentController.this.currentCommentEditedId = editCommentEvent.getId();
                if (editCommentEvent.shouldReposition()) {
                    InlineCommentController.this.repositionComments();
                }
            }
        });
        this.eventBus.addHandler(CommentDeletedEvent.TYPE, (EventHandler)new CommentDeletedEventHandler(){

            @Override
            public void onCommentDeletedEvent(CommentDeletedEvent commentDeletedEvent) {
                InlineCommentController.this.selectedLinesLocked = false;
                if (InlineCommentController.this.cep != null) {
                    InlineCommentController.this.positionController.unregisterContainerById(InlineCommentPositionController.NEW_CONTAINER_ID);
                    InlineCommentController.this.cep.destroy();
                    InlineCommentController.this.cep = null;
                } else {
                    InlineCommentController.this.positionController.unregisterContainerById(commentDeletedEvent.getId());
                    InlineCommentController.this.updatedCommentedLines(commentDeletedEvent.getId(), new int[0]);
                    InlineCommentController.this.repositionComments();
                }
                InlineCommentController.this.clearSelectedLines();
            }
        });
        this.eventBus.addHandler(EndEditCommentEvent.TYPE, (EventHandler)new EndEditCommentEventHandler(){

            public void onEndEditCommentEvent(EndEditCommentEvent event) {
                InlineCommentController.this.selectedLinesLocked = false;
                if (InlineCommentController.this.cep != null) {
                    InlineCommentController.this.positionController.unregisterContainerById(InlineCommentPositionController.NEW_CONTAINER_ID);
                    InlineCommentController.this.cep.destroy();
                    InlineCommentController.this.cep = null;
                }
                InlineCommentController.this.clearSelectedLines();
                InlineCommentController.this.repositionComments();
            }
        });
        this.eventBus.addHandler(EndEditCommentEvent.TYPE, (EventHandler)new EndEditCommentEventHandler<InlineCommentModel>(){

            @Override
            public void onEndEditCommentEvent(EndEditCommentEvent<InlineCommentModel> event) {
                if (event.getParentId() != -2) {
                    InlineCommentController.this.currentCommentEditedId = null;
                }
            }
        });
        this.eventBus.addHandler(CommentAddedEvent.TYPE, (EventHandler)new CommentAddedEventHandler<InlineCommentModel>(){

            @Override
            public void onCommentAddedEvent(CommentAddedEvent<InlineCommentModel> event) {
                InlineCommentController.this.selectedLinesLocked = false;
                Integer parentId = event.getParentId();
                if (parentId != -2) {
                    return;
                }
                Integer id = event.getId();
                InlineCommentModel comment = event.getComment();
                InlineCommentController.this.clearSelectedLines();
                InlineCommentContainer container = new InlineCommentContainer(parentId, id, comment, rpcService, InlineCommentController.this.eventBus, new ArrayList<CommentGO>(), InlineCommentController.this.lineSelector);
                InlineCommentController.this.positionController.registerContainer(container);
                InlineCommentController.this.insertComment(container, (LIElement)InlineCommentController.this.lineElements.get(comment.getLowestLine()));
                InlineCommentController.this.updatedCommentedLines(comment.getId(), comment.getLines());
                InlineCommentController.this.bindCommentHandlers(id, container);
            }
        });
    }

    private void bindCommentHandlers(final int id, final CommentContainer<InlineCommentModel, ?> container) {
        this.eventBus.addHandler(CreateInlineCommentEvent.TYPE, (EventHandler)new CreateInlineCommentEventHandler(){

            @Override
            public void onCreateInlineCommentEvent(CreateInlineCommentEvent event) {
                if (InlineCommentController.this.currentCommentEditedId != null && id == InlineCommentController.this.currentCommentEditedId) {
                    InlineCommentController.this.insertComment(container, (LIElement)InlineCommentController.this.lineElements.get(event.getLowestLine()));
                }
            }
        });
        this.eventBus.addHandler(EndEditCommentEvent.TYPE, (EventHandler)new EndEditCommentEventHandler<InlineCommentModel>(){

            @Override
            public void onEndEditCommentEvent(EndEditCommentEvent<InlineCommentModel> event) {
                if (InlineCommentController.this.currentCommentEditedId != null && id == InlineCommentController.this.currentCommentEditedId) {
                    InlineCommentController.this.currentCommentEditedId = null;
                    if (!event.isSave()) {
                        InlineCommentController.this.insertComment(container, (LIElement)InlineCommentController.this.lineElements.get(event.getComment().getLowestLine()));
                        InlineCommentController.this.repositionComments();
                    } else {
                        InlineCommentController.this.updatedCommentedLines(event.getId(), event.getComment().getLines());
                    }
                    InlineCommentController.this.selectedLinesLocked = false;
                    InlineCommentController.this.clearSelectedLines();
                }
            }
        });
    }

    private void insertComment(CommentContainer commentContainer, LIElement firstLine) {
        if (commentContainer instanceof InlineCommentContainer) {
            ((InlineCommentContainer)commentContainer).setLiElement(firstLine);
        }
        this.insertComment((Widget)commentContainer.getContainer());
    }

    private void insertComment(Widget w2) {
        this.containerCreator.getCommentPanel().add(w2);
        if (w2.isAttached() && !(w2 instanceof CommentEditDisplay)) {
            this.repositionComments();
        }
    }

    public void repositionComments() {
        this.repositionComments(null);
    }

    public void repositionComments(final Integer selectedComment) {
        if (this.awaitingReposition) {
            return;
        }
        this.awaitingReposition = true;
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                InlineCommentController.this.positionController.repositionComments();
                InlineCommentController.this.awaitingReposition = false;
                if (selectedComment != null) {
                    CommentUtil.scrollToCommentId(selectedComment);
                }
            }
        });
    }

    private void updatedCommentedLines(Integer commentId, int[] lines) {
        if (commentId == null) {
            return;
        }
        HashSet<Integer> newLines = new HashSet<Integer>();
        for (int line : lines) {
            newLines.add(line);
        }
        Set<Integer> oldLines = this.commentLines.get(commentId);
        if (oldLines != null) {
            Iterator<Integer> it = oldLines.iterator();
            while (it.hasNext()) {
                Integer oldLine = it.next();
                if (!newLines.remove(oldLine)) continue;
                it.remove();
            }
            for (Integer oldLine : oldLines) {
                this.updateHasCommentClass(oldLine, false);
            }
        }
        for (Integer newLine : newLines) {
            this.updateHasCommentClass(newLine, true);
        }
        this.commentLines.put(commentId, newLines);
    }

    private void updateHasCommentClass(Integer lineNumber, boolean commentAdded) {
        LIElement liElement = this.lineElements.get(lineNumber);
        int commentCount = liElement.getPropertyInt("commentCount");
        if (commentAdded) {
            if (++commentCount > 0) {
                liElement.addClassName("hasComment");
            }
        } else if (--commentCount == 0) {
            liElement.removeClassName("hasComment");
        }
        liElement.setPropertyInt("commentCount", commentCount);
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

