/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.snippet.client.ui;

import com.atlassian.fecru.gwt.comments.client.util.CommentUtil;
import com.atlassian.fecru.gwt.core.client.Rpc;
import com.atlassian.fecru.gwt.snippet.client.SnippetRPCService;
import com.atlassian.fecru.gwt.snippet.client.SnippetRPCServiceAsync;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentContainerCreator;
import com.atlassian.fecru.gwt.snippet.client.ui.comment.InlineCommentController;
import com.atlassian.fecru.gwt.snippet.client.ui.print.CommentPrintContainerCreator;
import com.atlassian.fecru.gwt.snippet.client.ui.widget.AUIHTMLPanel;
import com.atlassian.fecru.gwt.snippet.client.ui.widget.OrderedList;
import com.atlassian.fecru.gwt.snippet.shared.InlineCommentModel;
import com.atlassian.fecru.gwt.snippet.shared.ReviewGO;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;

public class MainSnippetPane
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    private InlineCommentController inlineCommentController;
    private SnippetRPCServiceAsync snippetService = (SnippetRPCServiceAsync)Rpc.setServiceRpcToken(GWT.create(SnippetRPCService.class));
    @UiField
    OrderedList linesList;
    @UiField
    AUIHTMLPanel inlineCommentArea;
    @UiField
    DivElement inlineCommentTip;
    @UiField
    HTMLPanel panel;
    @UiField
    AUIHTMLPanel printCommentArea;
    ReviewGO review;
    private HandlerManager eventBus;
    private final boolean isPrint;

    public MainSnippetPane(ReviewGO review, HandlerManager eventBus, boolean isPrint) {
        this.review = review;
        this.eventBus = eventBus;
        this.isPrint = isPrint;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.inlineCommentArea.getElement().setId(HTMLPanel.createUniqueId());
        if (!isPrint && review.isCommentable()) {
            this.linesList.addMouseDownHandler(new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    if (DOM.eventGetButton((Event)((Event)event.getNativeEvent().cast())) != 1) {
                        return;
                    }
                    LIElement target = MainSnippetPane.this.getSourceLine((MouseEvent)event);
                    if (target != null) {
                        MainSnippetPane.this.inlineCommentController.mouseDown(target);
                        event.preventDefault();
                    }
                }
            });
            this.linesList.addMouseMoveHandler(new MouseMoveHandler(){

                public void onMouseMove(MouseMoveEvent event) {
                    if (DOM.eventGetButton((Event)((Event)event.getNativeEvent().cast())) != 1) {
                        return;
                    }
                    LIElement target = MainSnippetPane.this.getSourceLine((MouseEvent)event);
                    if (target != null) {
                        MainSnippetPane.this.inlineCommentController.mouseMove(target);
                        event.preventDefault();
                    }
                }
            });
            this.linesList.addMouseUpHandler(new MouseUpHandler(){

                public void onMouseUp(MouseUpEvent event) {
                    if (DOM.eventGetButton((Event)((Event)event.getNativeEvent().cast())) != 1) {
                        return;
                    }
                    if (MainSnippetPane.this.getSourceLine((MouseEvent)event) != null) {
                        MainSnippetPane.this.inlineCommentController.mouseUp(event);
                    }
                }
            });
        } else {
            this.inlineCommentTip.removeFromParent();
        }
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                MainSnippetPane.this.inlineCommentController.repositionComments();
            }
        });
    }

    public void setupInlineComments() {
        this.inlineCommentController.setupInlineComments();
    }

    private LIElement getSourceLine(MouseEvent event) {
        Element target = (Element)event.getNativeEvent().getEventTarget().cast();
        while (target != null && !target.equals((Object)this.linesList.getElement())) {
            if (target.getClassName().contains("comment-container") || target.getClassName().contains("commentForm")) {
                return null;
            }
            if (target.getTagName().equalsIgnoreCase("LI") && target.getPropertyBoolean("sourceLine")) {
                return (LIElement)target.cast();
            }
            target = (Element)target.getParentElement().cast();
        }
        return null;
    }

    public void setLines(String[] lines) {
        HashMap<Integer, LIElement> lineElements = new HashMap<Integer, LIElement>();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            Element li = DOM.createElement((String)"LI");
            li.setPropertyInt("lineNum", i2 + 1);
            li.setPropertyBoolean("sourceLine", true);
            li.setInnerHTML("<pre>" + line + "</pre>");
            this.linesList.add(li);
            lineElements.put(i2 + 1, (LIElement)li.cast());
        }
        CommentPrintContainerCreator<InlineCommentModel> factory = this.isPrint ? new CommentPrintContainerCreator((Panel)this.printCommentArea) : new InlineCommentContainerCreator((Panel)this.inlineCommentArea);
        this.inlineCommentController = new InlineCommentController(this.eventBus, this.review, factory, this.linesList, lineElements, this.snippetService);
    }

    protected void onAttach() {
        super.onAttach();
        if (this.inlineCommentController != null) {
            this.inlineCommentController.repositionComments(CommentUtil.getCommentIdFromHash(Window.Location.getHash()));
        }
    }

    static interface MyUiBinder
    extends UiBinder<Widget, MainSnippetPane> {
    }
}

