/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.snippet.client;

import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.snippet.client.SnippetRPCServiceAsync;
import com.atlassian.fecru.gwt.snippet.shared.InlineCommentModel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Date;

public class BoundSnippetInlineCommentRPCService
implements CommentRPCService<InlineCommentModel> {
    private final SnippetRPCServiceAsync service;
    private String permaId;
    private int frxId;

    public BoundSnippetInlineCommentRPCService(SnippetRPCServiceAsync service, String permaId, int frxId) {
        this.service = service;
        this.permaId = permaId;
        this.frxId = frxId;
    }

    @Override
    public void createComment(Integer parentId, InlineCommentModel comment, AsyncCallback<InlineCommentModel> async) {
        if (parentId == null || parentId <= 0) {
            this.service.createInlineComment(this.permaId, comment, async);
        } else {
            this.service.createInlineReplyComment(this.permaId, parentId, comment, async);
        }
    }

    @Override
    public void updateComment(Integer parentId, int id, InlineCommentModel comment, AsyncCallback<InlineCommentModel> async) {
        if (parentId != null && parentId <= 0) {
            this.service.editInlineComment(this.permaId, comment, async);
        } else {
            this.service.editInlineReplyComment(this.permaId, comment, async);
        }
    }

    @Override
    public void deleteComment(Integer id, AsyncCallback<Boolean> async) {
        this.service.deleteComment(this.permaId, id, async);
    }

    @Override
    public InlineCommentModel getNewCommentModel(InlineCommentModel defaults) {
        return new InlineCommentModel(-1, "", "", null, new Date(), true, true, defaults.isDefect(), false, this.frxId, defaults.getLines());
    }

    @Override
    public InlineCommentModel convertCommentModel(CommentModel commentModel) {
        return new InlineCommentModel(commentModel, this.frxId, new int[0]);
    }
}

