/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.servlet;

import com.atlassian.fecru.security.SshKeyManager;
import com.cenqua.fisheye.config.SpringContext;
import com.jcraft.jsch.JSchException;
import gwtupload.server.UploadAction;
import gwtupload.server.exceptions.UploadActionException;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;

public class GwtSshKeyUploadServlet
extends UploadAction {
    private static final long serialVersionUID = 2L;
    public static final String ERROR_PREFIX = "ERROR:";
    public static final String INVALID_PREFIX = "INVALID:";
    private SshKeyManager sshKeyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeAction(HttpServletRequest request, List<FileItem> sessionFiles) throws UploadActionException {
        try {
            if (sessionFiles.size() != 1) {
                throw new UploadActionException("Must upload exactly 1 file");
            }
            FileItem item = sessionFiles.get(0);
            if (item.isFormField()) {
                throw new UploadActionException("Must not be a simple form field");
            }
            String contents = item.getString();
            try {
                if (this.getSshKeyManager().isEncrypted(contents)) {
                    String string = "INVALID:FishEye does not currently support private keys requiring a passphrase";
                    return string;
                }
            }
            catch (JSchException e2) {
                if (e2.getMessage().startsWith("invalid privatekey")) {
                    String string = "INVALID:The file you uploaded is not a valid private key";
                    return string;
                }
                String string = "ERROR:Could not save private key: " + e2.getMessage();
                return string;
            }
            catch (IOException e3) {
                String string = "ERROR:Could not save private key: " + e3.getMessage();
                GwtSshKeyUploadServlet.removeSessionFileItems((HttpServletRequest)request);
                return string;
            }
            String string = this.storeKeyInSession(contents, request.getSession());
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            GwtSshKeyUploadServlet.removeSessionFileItems((HttpServletRequest)request);
        }
    }

    private SshKeyManager getSshKeyManager() {
        if (this.sshKeyManager == null) {
            this.sshKeyManager = (SshKeyManager)SpringContext.getComponent("sshKeyManager");
        }
        return this.sshKeyManager;
    }

    private String storeKeyInSession(String contents, HttpSession session) {
        String newKey = UUID.randomUUID().toString();
        session.setAttribute(newKey + ".private", (Object)contents);
        return newKey;
    }

    public void getUploadedFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        GwtSshKeyUploadServlet.renderXmlResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"<error>downloading ssh keys is not supported</error>");
    }
}

