/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.servlet;

import com.atlassian.fecru.gwt.servlet.GwtRPCRequestTracker;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RpcToken;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.XsrfToken;
import com.google.gwt.user.server.rpc.AbstractXsrfProtectedServiceServlet;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;

public class GwtRPCRoutingServlet
extends AbstractXsrfProtectedServiceServlet {
    private AtomicReference<Collection<GwtRPCRequestTracker>> trackers = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCall(String payload) throws SerializationException {
        HttpServletRequest servletRequest = this.getCurrentRequest();
        HttpServletResponse servletResponse = this.getCurrentResponse();
        try {
            this.notifyRequestTrackers(servletRequest, servletResponse);
            RPCRequest rpcRequest = this.decodeRequest(payload);
            this.onAfterRequestDeserialized(rpcRequest);
            String pi = this.getCurrentRequest().getPathInfo();
            if (pi == null) {
                pi = "";
            }
            if (pi.startsWith("/")) {
                pi = pi.substring(1);
            }
            RemoteService target = this.findService(pi);
            String string = this.invokeRequest(rpcRequest, target);
            return string;
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            String string = this.encodeFailure(ex);
            return string;
        }
        catch (RpcTokenException ex) {
            this.log("An RpcTokenException was thrown while processing this call.", ex);
            String string = this.encodeFailure(ex);
            return string;
        }
        finally {
            this.clearRequestTrackers(servletRequest, servletResponse);
        }
    }

    protected HttpServletResponse getCurrentResponse() {
        return this.getThreadLocalResponse();
    }

    protected HttpServletRequest getCurrentRequest() {
        return this.getThreadLocalRequest();
    }

    protected String encodeFailure(Throwable ex) throws SerializationException {
        return RPC.encodeResponseForFailure(null, (Throwable)ex);
    }

    protected String invokeRequest(RPCRequest rpcRequest, RemoteService target) throws SerializationException {
        return RPC.invokeAndEncodeResponse((Object)target, (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy(), (int)rpcRequest.getFlags());
    }

    protected RPCRequest decodeRequest(String payload) {
        return RPC.decodeRequest((String)payload, null, (SerializationPolicyProvider)this);
    }

    protected void notifyRequestTrackers(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.ensureTrackersFound();
        for (GwtRPCRequestTracker tracker : this.trackers.get()) {
            tracker.onRequestStarted(servletRequest, servletResponse);
        }
    }

    protected void clearRequestTrackers(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.ensureTrackersFound();
        for (GwtRPCRequestTracker tracker : this.trackers.get()) {
            tracker.onRequestEnded(servletRequest, servletResponse);
        }
    }

    private void ensureTrackersFound() {
        if (this.trackers.get() == null) {
            ApplicationContext context = SpringContext.getApplicationContext();
            this.trackers.compareAndSet(null, context.getBeansOfType(GwtRPCRequestTracker.class).values());
        }
    }

    protected RemoteService findService(String pi) throws IncompatibleRemoteServiceException {
        ApplicationContext context = SpringContext.getApplicationContext();
        if (!context.containsBean(pi)) {
            throw new IncompatibleRemoteServiceException("Could not find service for path info " + pi);
        }
        Object component = context.getBean(pi);
        if (!(component instanceof RemoteService)) {
            Logs.APP_LOG.warn((Object)("Requested service path " + pi + " was not a RemoteService"));
            throw new IncompatibleRemoteServiceException("Could not find service for path info " + pi);
        }
        return (RemoteService)component;
    }

    protected void validateXsrfToken(RpcToken token, Method method) throws RpcTokenException {
        XsrfTokenAccessor tokenAccessor = this.getXsrfTokenAccessor();
        XsrfToken xsrfToken = (XsrfToken)token;
        String expectedToken = tokenAccessor.getXsrfToken(this.getThreadLocalRequest(), this.getThreadLocalResponse(), false);
        if (expectedToken == null || expectedToken.length() == 0) {
            throw new RpcTokenException("Expected XSRF token is empty or missing!");
        }
        if (xsrfToken == null || !expectedToken.equals(xsrfToken.getToken())) {
            throw new RpcTokenException("Invalid XSRF token");
        }
    }

    private XsrfTokenAccessor getXsrfTokenAccessor() {
        ApplicationContext context = SpringContext.getApplicationContext();
        return (XsrfTokenAccessor)context.getBean(XsrfTokenAccessor.class);
    }
}

