/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.cscomment.server;

import com.atlassian.fecru.gwt.comments.shared.CommentGO;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.comments.shared.InitialCommentDetails;
import com.atlassian.fecru.gwt.comments.util.UserModelFactory;
import com.atlassian.fecru.gwt.core.shared.UserMessageException;
import com.atlassian.fecru.gwt.cscomment.client.CsCommentRPCService;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.cenqua.fisheye.web.util.WikiMarkupFormatter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CsCommentRPCService")
public class CsCommentRPCServiceImpl
implements CsCommentRPCService {
    private final EffectiveUserProvider effectiveUserProvider;
    private ChangesetCommentManager changesetCommentManager;
    private WikiMarkupFormatter formatter;

    @Autowired
    public CsCommentRPCServiceImpl(EffectiveUserProvider effectiveUserProvider, ChangesetCommentManager changesetCommentManager) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.changesetCommentManager = changesetCommentManager;
        this.formatter = new WikiMarkupFormatter();
    }

    @Override
    public InitialCommentDetails getInitialCommentDetails(String repository, String csid) {
        ArrayList commentGos = Lists.newArrayList();
        boolean canSee = this.changesetCommentManager.canSeeComments(repository);
        boolean canAdd = canSee && this.changesetCommentManager.canAddComments(repository);
        int noOfComments = 0;
        if (canSee) {
            List<ChangesetComment> comments = this.changesetCommentManager.getCommentsForChangeset(repository, csid);
            noOfComments = comments.size();
            ArrayList topLevelComments = Lists.newArrayList();
            ArrayListMultimap repliesToParent = ArrayListMultimap.create();
            for (ChangesetComment cc : comments) {
                if (cc.getReplyToComment() != null) {
                    repliesToParent.put((Object)cc.getReplyToComment().getId(), (Object)cc);
                    continue;
                }
                topLevelComments.add(cc);
            }
            FecruUser currentUser = this.effectiveUserProvider.getEffectiveUser();
            for (ChangesetComment cc : topLevelComments) {
                commentGos.add(this.fromChangesetComment(-1, cc, currentUser, canAdd, (Multimap<Integer, ChangesetComment>)repliesToParent));
            }
        }
        return new InitialCommentDetails(canSee, canAdd, commentGos, noOfComments);
    }

    @Override
    public CommentModel createComment(String repository, String csid, Integer parentId, CommentModel comment) throws UserMessageException {
        try {
            return this.createCommentModelFromChangesetComment(this.changesetCommentManager.addNewComment(this.effectiveUserProvider.getEffectiveUser(), repository, csid, comment.getText(), parentId, comment.isDefect(), comment.isDraft()), true, true);
        }
        catch (Exception e2) {
            throw new UserMessageException(e2.getMessage());
        }
    }

    @Override
    public CommentModel updateComment(int id, CommentModel comment) throws UserMessageException {
        try {
            return this.createCommentModelFromChangesetComment(this.changesetCommentManager.updateComment(id, comment.getText(), comment.isDefect(), comment.isDraft()), true, true);
        }
        catch (Exception e2) {
            throw new UserMessageException(e2.getMessage());
        }
    }

    @Override
    public Boolean deleteComment(int id) throws UserMessageException {
        try {
            return this.changesetCommentManager.deleteComment(id);
        }
        catch (Exception e2) {
            throw new UserMessageException(e2.getMessage());
        }
    }

    private CommentModel createCommentModelFromChangesetComment(ChangesetComment csComment, boolean editable, boolean replyable) {
        return new CommentModel(csComment.getId(), csComment.getMessage(), this.formatter.formatText(csComment.getMessage(), csComment.getRepository()), UserModelFactory.fromUser(csComment.getUser()), csComment.getCreateDate(), editable, replyable, csComment.isDefectRaised(), csComment.isDraft());
    }

    private Map<Integer, CommentGO> makeCommentGOs(int parentId, FecruUser currentUser, boolean canAdd, Collection<ChangesetComment> comments, Multimap<Integer, ChangesetComment> repliesToParent) {
        LinkedHashMap cgs = Maps.newLinkedHashMap();
        if (comments != null) {
            for (ChangesetComment cc : comments) {
                cgs.put(cc.getId(), this.fromChangesetComment(parentId, cc, currentUser, canAdd, repliesToParent));
            }
        }
        return cgs;
    }

    private CommentGO fromChangesetComment(int parentId, ChangesetComment cc, FecruUser currentUser, boolean canAdd, Multimap<Integer, ChangesetComment> repliesToParent) {
        return new CommentGO(parentId, cc.getId(), cc.getMessage(), this.formatter.formatText(cc.getMessage(), cc.getRepository()), UserModelFactory.fromUser(cc.getUser()), cc.getCreateDate(), this.makeCommentGOs(cc.getId(), currentUser, canAdd, repliesToParent.get((Object)cc.getId()), repliesToParent), cc.getUser().equals(currentUser), canAdd, cc.isDefectRaised(), cc.isDraft());
    }
}

