/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.core.client;

import com.atlassian.fecru.gwt.core.client.EmptyAsyncCallback;
import com.atlassian.fecru.gwt.core.client.LoggingRPCService;
import com.atlassian.fecru.gwt.core.client.ui.ErrorDialog;
import com.atlassian.fecru.gwt.core.client.ui.ServerNotRespondingDialog;
import com.atlassian.fecru.gwt.core.shared.HumanReadableError;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;

public class Utils {
    private static DateTimeFormat FORMAT_LONG = DateTimeFormat.getFormat((String)"dd MMMM yyyy HH:mm");
    private static final DateTimeFormat FORMAT_BRIEF_TODAY = DateTimeFormat.getFormat((String)"HH:mm");
    private static final DateTimeFormat FORMAT_BRIEF_THIS_YEAR = DateTimeFormat.getFormat((String)"dd MMM");
    private static final DateTimeFormat FORMAT_BRIEF_FULL = DateTimeFormat.getFormat((String)"dd MMM yy");
    private static final DateTimeFormat FORMAT_YEAR = DateTimeFormat.getFormat((String)"yyyy");

    public static void makeElementVisible(Element e2, boolean visible) {
        e2.getStyle().setVisibility(visible ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
    }

    public static void hideElement(Element e2) {
        e2.getStyle().setDisplay(Style.Display.NONE);
    }

    public static void showElementBlock(Element e2) {
        e2.getStyle().setDisplay(Style.Display.BLOCK);
    }

    public static void showElementInline(Element e2) {
        e2.getStyle().setDisplay(Style.Display.INLINE);
    }

    public static void showElementInlineBlock(Element e2) {
        e2.getStyle().setDisplay(Style.Display.INLINE_BLOCK);
    }

    public static Element getGrandParent(UIObject object) {
        return object.getElement().getParentElement();
    }

    public static void addOrRemoveStyleName(UIObject uiObject, String name, boolean add) {
        if (add) {
            uiObject.addStyleName(name);
        } else {
            uiObject.removeStyleName(name);
        }
    }

    public static void swapStyleNames(UIObject uiObject, String trueName, String falseName, boolean state) {
        String removeName;
        String addName;
        if (state) {
            addName = trueName;
            removeName = falseName;
        } else {
            addName = falseName;
            removeName = trueName;
        }
        uiObject.addStyleName(addName);
        uiObject.removeStyleName(removeName);
    }

    public static void reportError(String errorMessage) {
        GWT.log((String)("Error:" + errorMessage));
        LoggingRPCService.App.getInstance().error(errorMessage, new EmptyAsyncCallback());
        Utils.reportUserError(errorMessage);
    }

    public static void reportUserError(String errorMessage) {
        ErrorDialog ed = new ErrorDialog();
        ed.addError(errorMessage);
        ed.show();
    }

    public static void reportServerNotResponding() {
        ServerNotRespondingDialog ed = new ServerNotRespondingDialog();
        ed.show();
    }

    public static void reportError(String errorMessage, Throwable t2) {
        GWT.log((String)errorMessage, (Throwable)t2);
        if (t2 instanceof StatusCodeException && ((StatusCodeException)t2).getStatusCode() == 0) {
            Utils.reportServerNotResponding();
        } else if (t2 instanceof HumanReadableError) {
            Utils.reportUserError(((HumanReadableError)((Object)t2)).getHumanReadableError());
        } else {
            String s2 = errorMessage + ":" + t2.toString();
            for (StackTraceElement e2 : t2.getStackTrace()) {
                s2 = s2 + "\n        " + e2.toString();
            }
            LoggingRPCService.App.getInstance().error(s2, new EmptyAsyncCallback());
            ErrorDialog ed = new ErrorDialog();
            ed.addError(s2);
            ed.show();
        }
    }

    public static void logError(String errorMessage) {
        GWT.log((String)errorMessage);
        LoggingRPCService.App.getInstance().error(errorMessage, new EmptyAsyncCallback());
    }

    public static GWT.UncaughtExceptionHandler uncaughtExceptionHandler(final String source) {
        return new GWT.UncaughtExceptionHandler(){

            public void onUncaughtException(Throwable e2) {
                if (e2 instanceof HumanReadableError) {
                    Utils.reportUserError(((HumanReadableError)((Object)e2)).getHumanReadableError());
                } else {
                    Utils.reportError(source, e2);
                }
            }
        };
    }

    public static String longDate(Date date) {
        return FORMAT_LONG.format(date, (TimeZone)Utils.getTimeZone());
    }

    public static String shortDate(Date date, Date now) {
        com.google.gwt.i18n.client.TimeZone timeZone = Utils.getTimeZone();
        if (now.getTime() < date.getTime()) {
            return FORMAT_BRIEF_FULL.format(date, (TimeZone)timeZone);
        }
        if (CalendarUtil.isSameDate((Date)now, (Date)date)) {
            return FORMAT_BRIEF_TODAY.format(date, (TimeZone)timeZone);
        }
        if (Utils.isSameYear(now, date)) {
            return FORMAT_BRIEF_THIS_YEAR.format(date, (TimeZone)timeZone);
        }
        return FORMAT_BRIEF_FULL.format(date, (TimeZone)timeZone);
    }

    private static boolean isSameYear(Date d1, Date d2) {
        return FORMAT_YEAR.format(d1).equals(FORMAT_YEAR.format(d2));
    }

    public static Element getElementById(String id) {
        com.google.gwt.user.client.Element e2 = DOM.getElementById((String)id);
        if (e2 == null) {
            Utils.reportError("Page does not contain an element with id '" + id + "'");
            return null;
        }
        return e2;
    }

    public static String getContext() {
        String s2 = Utils.readFishEyePageContext();
        if (s2 == null) {
            Utils.reportError("Couldn't find fishEyePageContext value");
        }
        return s2;
    }

    public static com.google.gwt.i18n.client.TimeZone getTimeZone() {
        String userPreferredTZOffset = Utils.readFishEyeUserTimeZoneOffset();
        int offset = new Date().getTimezoneOffset();
        if (userPreferredTZOffset == null) {
            Utils.logError("Error: Couldn't find a fishEyeUserTimeZoneOffset value");
        } else {
            try {
                offset = Integer.parseInt(userPreferredTZOffset);
            }
            catch (NumberFormatException e2) {
                Utils.logError("Error: Couldn't find a fishEyeUserTimeZoneOffset value");
            }
        }
        return com.google.gwt.i18n.client.TimeZone.createTimeZone((int)(-offset));
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || "".equals(value.trim());
    }

    private static native String readFishEyePageContext();

    private static native String readFishEyeUserTimeZoneOffset();

    public static native void fireCustomJavascriptEvent(String var0);
}

