/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.core.client;

import com.atlassian.fecru.gwt.core.client.Spinner;
import com.atlassian.fecru.gwt.core.client.Utils;
import com.atlassian.fecru.gwt.core.shared.HumanReadableError;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

public abstract class BaseAsyncCallback<T>
implements AsyncCallback<T> {
    Spinner spinner;

    public BaseAsyncCallback(Spinner spinner) {
        this.spinner = spinner;
        if (spinner != null) {
            spinner.showSpinner(true);
        }
    }

    public BaseAsyncCallback() {
        this(null);
    }

    public void onFailure(Throwable caught) {
        this.stopSpinner();
        caught.printStackTrace();
        if (caught instanceof HumanReadableError) {
            this.reportHumanReadableError((HumanReadableError)((Object)caught));
        } else {
            this.failure(caught);
        }
    }

    public void onSuccess(T result) {
        try {
            this.success(result);
        }
        finally {
            this.stopSpinner();
        }
    }

    protected abstract void success(T var1);

    protected void failure(Throwable caught) {
        this.reportError(caught);
    }

    protected void reportError(Throwable caught) {
        if (GWT.isClient()) {
            Utils.reportError("Error calling server", caught);
        } else {
            System.err.println("Error calling server: " + caught.getMessage());
            caught.printStackTrace();
        }
    }

    protected void reportHumanReadableError(HumanReadableError caught) {
        Utils.reportUserError(caught.getHumanReadableError());
    }

    protected void stopSpinner() {
        if (this.spinner != null) {
            this.spinner.showSpinner(false);
        }
    }
}

