/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.comments.client.ui;

import com.atlassian.fecru.gwt.comments.client.ui.CommentPresenterUtils;
import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.client.ui.HandlerSet;
import com.atlassian.fecru.gwt.comments.client.ui.HasPixelHeight;
import com.atlassian.fecru.gwt.comments.client.ui.IdComparator;
import com.atlassian.fecru.gwt.comments.client.ui.ViewDisplay;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentChangedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentChangedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentSelectedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentSelectedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.ScrollToCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.ScrollToCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.util.CommentUtil;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.core.client.BaseAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Widget;

public class CommentViewPresenter<T extends CommentModel> {
    private final Integer parentId;
    private final Integer id;
    private T comment;
    private final HandlerSet eventBus;
    private Display display;
    private final CommentRPCService<T> rpcService;
    private int childCommentCount;

    public CommentViewPresenter(Integer parentId, Integer id, T comment, CommentRPCService<T> rpcService, HandlerManager eventBus, Display display, int childCommentCount) {
        this.parentId = parentId;
        this.id = id;
        this.comment = comment;
        this.eventBus = new HandlerSet(eventBus);
        this.display = display;
        this.rpcService = rpcService;
        this.childCommentCount = childCommentCount;
        this.bindDisplay();
        this.bindEvents();
    }

    private void bindEvents() {
        this.eventBus.addHandler(EditCommentEvent.TYPE, new EditCommentEventHandler<T>(){

            @Override
            public void onEditCommentEvent(EditCommentEvent<T> event) {
                CommentViewPresenter.this.disableButtons();
            }
        });
        this.eventBus.addHandler(EndEditCommentEvent.TYPE, new EndEditCommentEventHandler(){

            public void onEndEditCommentEvent(EndEditCommentEvent event) {
                CommentViewPresenter.this.enableButtons();
                if (event.getId() != null && event.getId().equals(CommentViewPresenter.this.id)) {
                    CommentViewPresenter.this.display.showDisplay(true);
                }
            }
        });
        this.eventBus.addHandler(CommentChangedEvent.TYPE, new CommentChangedEventHandler<T>(){

            @Override
            public void onCommentChangedEvent(CommentChangedEvent<T> e2) {
                if (e2.getId() == CommentViewPresenter.this.id.intValue()) {
                    CommentViewPresenter.this.comment = e2.getComment();
                    CommentViewPresenter.this.reinitComment();
                }
            }
        });
        this.eventBus.addHandler(CommentDeletedEvent.TYPE, new CommentDeletedEventHandler(){

            @Override
            public void onCommentDeletedEvent(CommentDeletedEvent event) {
                CommentViewPresenter.this.changeChildCommentCount(event, -1);
            }
        });
        this.eventBus.addHandler(CommentAddedEvent.TYPE, new CommentAddedEventHandler(){

            public void onCommentAddedEvent(CommentAddedEvent event) {
                CommentViewPresenter.this.changeChildCommentCount(event, 1);
            }
        });
        this.eventBus.addHandler(CommentSelectedEvent.TYPE, new CommentSelectedEventHandler(){

            @Override
            public void onCommentSelectedEvent(CommentSelectedEvent event) {
                CommentViewPresenter.this.display.setSelected(event.getId() == CommentViewPresenter.this.id.intValue());
            }
        });
        this.eventBus.addHandler(ScrollToCommentEvent.TYPE, new ScrollToCommentEventHandler(){

            @Override
            public void onScrollToCommentEvent(ScrollToCommentEvent event) {
                if (event.getId() == CommentViewPresenter.this.id.intValue()) {
                    CommentUtil.scrollToCommentInContainer(CommentViewPresenter.this.id, "#comment-comments");
                }
            }
        });
    }

    private void changeChildCommentCount(CommentEvent event, int delta) {
        if (this.isOurChild(event)) {
            this.childCommentCount += delta;
            this.display.enableDeleteButton(this.childCommentCount == 0);
        }
    }

    private boolean isOurChild(CommentEvent e2) {
        return IdComparator.equal(e2.getParentId(), this.id);
    }

    private void bindDisplay() {
        this.display.showDisplay(true);
        this.reinitComment();
        this.display.getEditButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CommentViewPresenter.this.eventBus.fireEvent(new EditCommentEvent<CommentModel>(CommentViewPresenter.this.parentId, CommentViewPresenter.this.id, CommentViewPresenter.this.comment, CommentViewPresenter.this.display, false));
                CommentViewPresenter.this.display.showDisplay(false);
            }
        });
        this.display.getReplyButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CommentViewPresenter.this.eventBus.fireEvent(new EditCommentEvent<CommentModel>(CommentViewPresenter.this.id, null, CommentViewPresenter.this.comment, null, true));
            }
        });
        this.display.getDeleteButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CommentPresenterUtils.delete(CommentViewPresenter.this.rpcService, CommentViewPresenter.this.eventBus, CommentViewPresenter.this.parentId, CommentViewPresenter.this.id);
            }
        });
        this.display.getPostButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CommentViewPresenter.this.comment.setDraft(false);
                CommentViewPresenter.this.rpcService.updateComment(CommentViewPresenter.this.parentId, CommentViewPresenter.this.id, CommentViewPresenter.this.comment, new BaseAsyncCallback<T>(){

                    @Override
                    public void success(T model) {
                        CommentViewPresenter.this.eventBus.fireEvent(new CommentChangedEvent(CommentViewPresenter.this.id, model));
                    }
                });
            }
        });
    }

    private void reinitComment() {
        this.display.getBody().setHTML(((CommentModel)this.comment).getHtml());
        this.display.setAvatarImageUrl(((CommentModel)this.comment).getAuthor().getAvatarUrl());
        this.display.setAvatarLinkHref(((CommentModel)this.comment).getAuthor().getUrl());
        this.display.setAuthorHeadingLinkHref(((CommentModel)this.comment).getAuthor().getUrl());
        this.display.setAuthorName(((CommentModel)this.comment).getAuthor().getDisplayName());
        this.display.showDefectMark(((CommentModel)this.comment).isDefect());
        this.display.showDraftMark(((CommentModel)this.comment).isDraft());
        this.display.setCreateDate(((CommentModel)this.comment).getCreateDate());
        this.display.setPermalinkUrl("#c" + ((CommentModel)this.comment).getId());
        this.enableButtons();
    }

    private void disableButtons() {
        this.display.enableEditButton(false);
        this.display.enableDeleteButton(false);
        this.display.enableReplyButton(false);
        this.display.enablePostButton(false);
    }

    private void enableButtons() {
        this.display.showEditButton(((CommentModel)this.comment).isEditable());
        this.display.enableEditButton(((CommentModel)this.comment).isEditable());
        this.display.showDeleteButton(((CommentModel)this.comment).isEditable());
        this.display.enableDeleteButton(this.childCommentCount == 0);
        this.display.enableReplyButton(((CommentModel)this.comment).isReplyable() && !((CommentModel)this.comment).isDraft());
        this.display.enablePostButton(((CommentModel)this.comment).isDraft());
        this.display.showPostButton(((CommentModel)this.comment).isDraft());
    }

    protected T getComment() {
        return this.comment;
    }

    public static interface Display
    extends HasPixelHeight,
    ViewDisplay {
        public HasClickHandlers getEditButton();

        public HasClickHandlers getReplyButton();

        public HasClickHandlers getDeleteButton();

        public HasClickHandlers getPostButton();

        public void showEditButton(boolean var1);

        public void enableReplyButton(boolean var1);

        public void enableDeleteButton(boolean var1);

        public void showDeleteButton(boolean var1);

        public void enablePostButton(boolean var1);

        public void showPostButton(boolean var1);

        public void showDefectMark(boolean var1);

        public void showDraftMark(boolean var1);

        public Widget asWidget();

        public void setPermalinkUrl(String var1);

        public void setSelected(boolean var1);

        public void enableEditButton(boolean var1);
    }
}

