/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.comments.client.ui;

import com.atlassian.fecru.gwt.comments.client.ui.CommentViewPresenter;
import com.atlassian.fecru.gwt.core.client.Utils;
import com.atlassian.fecru.gwt.core.client.ui.FECRUAnchor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

public class CommentViewDisplay
extends Composite
implements CommentViewPresenter.Display {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    InlineLabel author;
    @UiField
    HTML message;
    @UiField
    Anchor reply;
    @UiField
    Anchor edit;
    @UiField
    Anchor delete;
    @UiField
    HTMLPanel panel;
    @UiField
    AnchorElement avatarLink;
    @UiField
    Image avatar;
    @UiField
    AnchorElement authorHeadingLink;
    @UiField
    InlineLabel defect;
    @UiField
    InlineLabel draft;
    @UiField
    FECRUAnchor post;
    @UiField
    Label date;
    @UiField
    Anchor permaLink;
    private static final String AVATAR_SIZE = "24";

    public CommentViewDisplay() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.avatar.setHeight("24px");
        this.avatar.setWidth("24px");
    }

    @Override
    public HasHTML getBody() {
        return this.message;
    }

    @Override
    public void setAvatarLinkHref(String url) {
        this.avatarLink.setHref(url);
    }

    @Override
    public void setAvatarImageUrl(String url) {
        String defaultSize = String.valueOf(48);
        url = url.replace("s=" + defaultSize, "s=24");
        url = url.replace("s%3D" + defaultSize, "s%3D24");
        this.avatar.setUrl(url);
    }

    @Override
    public void setAuthorHeadingLinkHref(String url) {
        this.authorHeadingLink.setHref(url);
    }

    @Override
    public void setAuthorName(String displayName) {
        this.authorHeadingLink.setInnerText(displayName);
    }

    @Override
    public HasClickHandlers getEditButton() {
        return this.edit;
    }

    @Override
    public HasClickHandlers getReplyButton() {
        return this.reply;
    }

    @Override
    public HasClickHandlers getDeleteButton() {
        return this.delete;
    }

    @Override
    public HasClickHandlers getPostButton() {
        return this.post;
    }

    @Override
    public void showEditButton(boolean show) {
        this.edit.setVisible(show);
    }

    @Override
    public void enableEditButton(boolean show) {
        this.edit.setEnabled(show);
    }

    @Override
    public void enableReplyButton(boolean enable) {
        this.reply.setEnabled(enable);
    }

    @Override
    public void enableDeleteButton(boolean enable) {
        this.delete.setEnabled(enable);
    }

    @Override
    public void showDeleteButton(boolean show) {
        this.delete.setVisible(show);
    }

    @Override
    public void enablePostButton(boolean enable) {
        this.post.setEnabled(enable);
    }

    @Override
    public void showPostButton(boolean show) {
        this.post.setVisible(show);
    }

    @Override
    public void showDefectMark(boolean show) {
        this.defect.setVisible(show);
        Utils.addOrRemoveStyleName((UIObject)this, "defect", show);
    }

    @Override
    public void showDraftMark(boolean show) {
        this.draft.setVisible(show);
        Utils.addOrRemoveStyleName((UIObject)this, "draft", show);
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    @Override
    public void setCreateDate(Date newDate) {
        Date now = new Date();
        this.date.setTitle(Utils.longDate(newDate));
        this.date.setText(Utils.shortDate(newDate, now));
    }

    @Override
    public void setPermalinkUrl(String url) {
        this.permaLink.setHref(url);
    }

    @Override
    public void setSelected(boolean selected) {
        Utils.addOrRemoveStyleName((UIObject)this, "current_comment", selected);
        if (selected) {
            this.getElement().scrollIntoView();
        }
    }

    @Override
    public int getBodyPixelHeight() {
        return this.panel.getOffsetHeight();
    }

    @Override
    public void showDisplay(boolean show) {
        this.setVisible(show);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, CommentViewDisplay> {
    }
}

