/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.comments.client.ui;

import com.atlassian.fecru.gwt.comments.client.ui.CommentContainer;
import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.client.ui.HandlerSet;
import com.atlassian.fecru.gwt.comments.client.ui.IdComparator;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEventHandler;
import com.atlassian.fecru.gwt.comments.shared.CommentGO;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommentListPresenter<T extends CommentModel> {
    private final Display<T> commentContainer;
    private final CommentRPCService<T> rpcService;
    private final HandlerManager handlerManager;
    private final HandlerSet eventBus;
    private final Integer parentId;
    private Map<Integer, CommentContainer> comments = new HashMap<Integer, CommentContainer>();

    public CommentListPresenter(Display<T> commentContainer, CommentRPCService<T> rpcService, HandlerManager handlerManager, final Integer parentId, List<CommentGO> initialComments) {
        this.commentContainer = commentContainer;
        this.rpcService = rpcService;
        this.handlerManager = handlerManager;
        this.eventBus = new HandlerSet(handlerManager);
        this.parentId = parentId;
        this.eventBus.addHandler(CommentAddedEvent.TYPE, new CommentAddedEventHandler<T>(){

            @Override
            public void onCommentAddedEvent(CommentAddedEvent<T> event) {
                if (IdComparator.equal(parentId, event.getParentId())) {
                    CommentListPresenter.this.addComment(event.getId(), event.getComment(), new ArrayList());
                }
            }
        });
        this.eventBus.addHandler(CommentDeletedEvent.TYPE, new CommentDeletedEventHandler(){

            @Override
            public void onCommentDeletedEvent(CommentDeletedEvent event) {
                CommentContainer cp = (CommentContainer)CommentListPresenter.this.comments.get(event.getId());
                if (cp != null) {
                    cp.getContainer().removeFromParent();
                    CommentListPresenter.this.comments.remove(event.getId());
                }
            }
        });
        for (CommentGO c2 : initialComments) {
            this.addComment(c2.getId(), rpcService.convertCommentModel(new CommentModel(c2.getId(), c2.getText(), c2.getHtml(), c2.getAuthor(), c2.getCreateDate(), c2.isEditable(), c2.isCommentable(), c2.isDefect(), c2.isDraft())), new ArrayList<CommentGO>(c2.getReplies().values()));
        }
    }

    private void addComment(int id, T comment, List<CommentGO> replies) {
        CommentContainer<T, ?> container = this.commentContainer.addCommentContainer(this.parentId, id, comment, this.rpcService, this.handlerManager, replies);
        this.comments.put(id, container);
    }

    public static interface Display<T extends CommentModel> {
        public CommentContainer<T, ?> addCommentContainer(Integer var1, Integer var2, T var3, CommentRPCService<T> var4, HandlerManager var5, List<CommentGO> var6);

        public Widget asWidget();
    }
}

