/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.comments.client.ui;

import com.atlassian.fecru.gwt.comments.client.ui.Autosave;
import com.atlassian.fecru.gwt.comments.client.ui.CommentPresenterUtils;
import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.client.ui.HandlerSet;
import com.atlassian.fecru.gwt.comments.client.ui.HasPixelHeight;
import com.atlassian.fecru.gwt.comments.client.ui.IdComparator;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentChangedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentChangedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEvent;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.core.client.BaseAsyncCallback;
import com.atlassian.fecru.gwt.core.client.Spinner;
import com.atlassian.fecru.gwt.core.client.Utils;
import com.atlassian.fecru.gwt.core.util.GwtStringUtil;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasKeyPressHandlers;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.HasValue;
import java.util.Date;

public class CommentEditPresenter<T extends CommentModel> {
    private final CommentRPCService<T> rpcService;
    private Display display;
    private HandlerSet eventBus;
    private Integer parentId;
    private Integer id;
    protected T comment;
    private Autosave autosave;

    public void destroy() {
        this.display.removeFromParent();
        this.eventBus.deregister();
    }

    public CommentEditPresenter(CommentRPCService<T> rpcService, HandlerManager eventBus, Display display, Integer parentId, Integer id, T comment) {
        this.rpcService = rpcService;
        this.display = display;
        this.eventBus = new HandlerSet(eventBus);
        this.parentId = parentId;
        this.id = id;
        this.comment = comment;
        this.bindDisplay();
        this.bindEvents();
    }

    protected Integer getId() {
        return this.id;
    }

    protected void updateCommentFromEditedData() {
        ((CommentModel)this.comment).setText((String)this.display.getBody().getValue());
        ((CommentModel)this.comment).setDefect(this.display.isDefect());
    }

    private boolean isNewComment() {
        return this.id == null || this.id < 0;
    }

    private void bindDisplay() {
        this.display.hideEditor();
        this.display.getSaveButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CommentEditPresenter.this.saveComment(false);
            }
        });
        this.display.getCancelButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                CommentEditPresenter.this.display.disableButtons();
                CommentEditPresenter.this.autosave.cancel(new Autosave.Cancel(){

                    @Override
                    public void stopped() {
                        if (((CommentModel)CommentEditPresenter.this.comment).isDraft() && ((CommentModel)CommentEditPresenter.this.comment).getId() > 0) {
                            CommentPresenterUtils.delete(CommentEditPresenter.this.rpcService, CommentEditPresenter.this.eventBus, CommentEditPresenter.this.parentId, ((CommentModel)CommentEditPresenter.this.comment).getId());
                        }
                    }
                });
                CommentEditPresenter.this.display.hideEditor();
                CommentEditPresenter.this.eventBus.fireEvent(new EndEditCommentEvent(false, CommentEditPresenter.this.parentId, CommentEditPresenter.this.id, CommentEditPresenter.this.comment));
            }
        });
        this.display.getBodyKeyPressHandlers().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CommentEditPresenter.this.display.setAutoSaveMessage("");
                if (CommentEditPresenter.this.isNewComment()) {
                    CommentEditPresenter.this.autosave.changed();
                }
            }
        });
    }

    private void saveComment(final boolean draft) {
        if (GwtStringUtil.nullOrEmpty((CharSequence)this.display.getBody().getValue())) {
            this.display.setAutoSaveMessage("Cannot " + (draft ? "save" : "post") + " empty comment.");
        } else {
            this.display.disableButtons();
            this.autosave.cancel(new Autosave.Cancel(){

                @Override
                public void stopped() {
                    CommentEditPresenter.this.updateCommentFromEditedData();
                    ((CommentModel)CommentEditPresenter.this.comment).setDraft(draft);
                    if (((CommentModel)CommentEditPresenter.this.comment).getId() < 1) {
                        CommentEditPresenter.this.rpcService.createComment(CommentEditPresenter.this.parentId, CommentEditPresenter.this.comment, new BaseAsyncCallback<T>(CommentEditPresenter.this.display.getSpinner()){

                            @Override
                            public void success(T model) {
                                ((CommentModel)CommentEditPresenter.this.comment).setId(((CommentModel)model).getId());
                                CommentEditPresenter.this.eventBus.fireEvent(new EndEditCommentEvent(true, CommentEditPresenter.this.parentId, CommentEditPresenter.this.id, CommentEditPresenter.this.comment));
                                CommentEditPresenter.this.display.hideEditor();
                                CommentEditPresenter.this.eventBus.fireEvent(new CommentAddedEvent(CommentEditPresenter.this.parentId, ((CommentModel)model).getId(), model));
                                CommentEditPresenter.this.fireCommentAddedEvent();
                            }

                            @Override
                            public void onFailure(Throwable caught) {
                                super.onFailure(caught);
                                CommentEditPresenter.this.display.enableButtons();
                            }
                        });
                    } else {
                        CommentEditPresenter.this.rpcService.updateComment(CommentEditPresenter.this.parentId, ((CommentModel)CommentEditPresenter.this.comment).getId(), CommentEditPresenter.this.comment, new BaseAsyncCallback<T>(CommentEditPresenter.this.display.getSpinner()){

                            @Override
                            public void success(T model) {
                                CommentEditPresenter.this.eventBus.fireEvent(new EndEditCommentEvent(true, CommentEditPresenter.this.parentId, CommentEditPresenter.this.id, CommentEditPresenter.this.comment));
                                CommentEditPresenter.this.display.hideEditor();
                                if (CommentEditPresenter.this.isNewComment()) {
                                    CommentEditPresenter.this.eventBus.fireEvent(new CommentAddedEvent(CommentEditPresenter.this.parentId, ((CommentModel)model).getId(), model));
                                    CommentEditPresenter.this.fireCommentAddedEvent();
                                } else {
                                    CommentEditPresenter.this.eventBus.fireEvent(new CommentChangedEvent(CommentEditPresenter.this.id, model));
                                }
                            }

                            @Override
                            public void onFailure(Throwable caught) {
                                super.onFailure(caught);
                                CommentEditPresenter.this.display.enableButtons();
                            }
                        });
                    }
                }
            });
        }
    }

    public void autosave(final Runnable callback) {
        this.updateCommentFromEditedData();
        if (!GwtStringUtil.nullOrEmpty(((CommentModel)this.comment).getText())) {
            this.display.setAutoSaveMessage("Autosaving...");
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    if (((CommentModel)CommentEditPresenter.this.comment).getId() < 1) {
                        ((CommentModel)CommentEditPresenter.this.comment).setDraft(true);
                        CommentEditPresenter.this.rpcService.createComment(CommentEditPresenter.this.parentId, CommentEditPresenter.this.comment, new BaseAsyncCallback<T>(CommentEditPresenter.this.display.getSpinner()){

                            @Override
                            public void success(T model) {
                                ((CommentModel)CommentEditPresenter.this.comment).setId(((CommentModel)model).getId());
                                callback.run();
                                CommentEditPresenter.this.showAutosavedTime();
                            }
                        });
                    } else {
                        CommentEditPresenter.this.rpcService.updateComment(CommentEditPresenter.this.parentId, ((CommentModel)CommentEditPresenter.this.comment).getId(), CommentEditPresenter.this.comment, new BaseAsyncCallback<T>(CommentEditPresenter.this.display.getSpinner()){

                            @Override
                            public void success(T model) {
                                callback.run();
                                CommentEditPresenter.this.showAutosavedTime();
                            }
                        });
                    }
                }
            });
        } else {
            callback.run();
        }
    }

    private void showAutosavedTime() {
        Date now = new Date();
        this.display.setAutoSaveMessage("Autosaved at " + Utils.shortDate(now, now));
    }

    private void bindEvents() {
        this.eventBus.addHandler(EditCommentEvent.TYPE, new EditCommentEventHandler<T>(){

            @Override
            public void onEditCommentEvent(EditCommentEvent<T> event) {
                if (IdComparator.equal(event.getParentId(), CommentEditPresenter.this.parentId) && IdComparator.equal(event.getId(), CommentEditPresenter.this.id)) {
                    if (CommentEditPresenter.this.id == null) {
                        CommentEditPresenter.this.comment = CommentEditPresenter.this.rpcService.getNewCommentModel(event.getCommentDefaults());
                    }
                    CommentEditPresenter.this.display.getBody().setValue((Object)((CommentModel)CommentEditPresenter.this.comment).getText());
                    CommentEditPresenter.this.display.setDefect(((CommentModel)CommentEditPresenter.this.comment).isDefect());
                    CommentEditPresenter.this.display.setSaveButtonText(CommentEditPresenter.this.isNewComment() || CommentEditPresenter.this.comment != null && ((CommentModel)CommentEditPresenter.this.comment).isDraft() ? "Post" : "Save");
                    CommentEditPresenter.this.display.showDefectControl(CommentEditPresenter.this.parentId == null || CommentEditPresenter.this.parentId < 0);
                    CommentEditPresenter.this.display.setAutoSaveMessage("");
                    CommentEditPresenter.this.display.enableButtons();
                    CommentEditPresenter.this.display.showEditor(event.getHeight());
                    CommentEditPresenter.this.autosave = new Autosave(CommentEditPresenter.this.comment, CommentEditPresenter.this);
                }
            }
        });
        this.eventBus.addHandler(CommentChangedEvent.TYPE, new CommentChangedEventHandler<T>(){

            @Override
            public void onCommentChangedEvent(CommentChangedEvent<T> e2) {
                if (CommentEditPresenter.this.id != null && CommentEditPresenter.this.id.intValue() == e2.getId()) {
                    CommentEditPresenter.this.comment = e2.getComment();
                }
            }
        });
        this.eventBus.addHandler(CommentDeletedEvent.TYPE, new CommentDeletedEventHandler(){

            @Override
            public void onCommentDeletedEvent(CommentDeletedEvent event) {
                if (CommentEditPresenter.this.id != null && event.getId().equals(CommentEditPresenter.this.id)) {
                    CommentEditPresenter.this.display.removeFromParent();
                    CommentEditPresenter.this.eventBus.deregister();
                }
            }
        });
    }

    private native void fireCommentAddedEvent();

    public static interface Display {
        public HasValue<String> getBody();

        public HasKeyPressHandlers getBodyKeyPressHandlers();

        public HasClickHandlers getSaveButton();

        public void setSaveButtonText(String var1);

        public HasClickHandlers getCancelButton();

        public void showEditor(HasPixelHeight var1);

        public void hideEditor();

        public void removeFromParent();

        public boolean isDefect();

        public void setDefect(boolean var1);

        public void showDefectControl(boolean var1);

        public void setAutoSaveMessage(String var1);

        public Spinner getSpinner();

        public void enableButtons();

        public void disableButtons();
    }
}

