/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.comments.client.ui;

import com.atlassian.fecru.gwt.comments.client.ui.CommentContainer;
import com.atlassian.fecru.gwt.comments.client.ui.CommentEditDisplay;
import com.atlassian.fecru.gwt.comments.client.ui.CommentEditPresenter;
import com.atlassian.fecru.gwt.comments.client.ui.CommentListDisplay;
import com.atlassian.fecru.gwt.comments.client.ui.CommentListPresenter;
import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.client.ui.CommentViewPresenter;
import com.atlassian.fecru.gwt.comments.client.ui.HandlerSet;
import com.atlassian.fecru.gwt.comments.client.ui.SimpleCommentContainerCreator;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEventHandler;
import com.atlassian.fecru.gwt.comments.shared.CommentGO;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public abstract class BaseEditableCommentContainer<T extends CommentModel, D extends CommentViewPresenter.Display>
extends CommentContainer<T, D> {
    private HandlerSet eventBus;
    private Integer id;
    protected final T comment;
    private final CommentRPCService<T> rpcService;
    private final HandlerManager handlerManager;
    private final List<CommentGO> replies;
    private final Integer parentId;

    public BaseEditableCommentContainer(Integer parentId, Integer id, T comment, CommentRPCService<T> rpcService, HandlerManager handlerManager, List<CommentGO> replies) {
        super(id);
        this.parentId = parentId;
        this.id = id;
        this.comment = comment;
        this.rpcService = rpcService;
        this.handlerManager = handlerManager;
        this.replies = replies;
    }

    protected void init() {
        D form = this.createCommentViewDisplay();
        CommentEditDisplay edit = this.createCommentEditDisplay();
        CommentEditDisplay reply = this.createCommentEditDisplay();
        reply.addStyleName("reply");
        CommentListDisplay repliesDisplay = new CommentListDisplay(new SimpleCommentContainerCreator());
        this.container.add(form.asWidget());
        this.container.add((Widget)edit);
        this.container.add((Widget)reply);
        this.container.add((Widget)repliesDisplay);
        this.eventBus = new HandlerSet(this.handlerManager);
        this.displays = new CommentListDisplay.Displays(form, edit, reply, repliesDisplay, this.container);
        this.createFormPresenter(this.parentId, this.id, this.comment, this.rpcService, this.handlerManager, this.replies);
        this.createEditPresenter(this.parentId, this.id, this.comment, this.rpcService, this.handlerManager);
        this.createReplyPresenter(this.id, this.comment, this.rpcService, this.handlerManager);
        this.createChildrenPresenter(this.id, this.rpcService, this.handlerManager, this.replies);
        this.bindEvents();
    }

    protected abstract D createCommentViewDisplay();

    protected CommentEditDisplay createCommentEditDisplay() {
        return new CommentEditDisplay();
    }

    public T getCommentModel() {
        return this.comment;
    }

    private void bindEvents() {
        this.eventBus.addHandler(CommentDeletedEvent.TYPE, new CommentDeletedEventHandler(){

            @Override
            public void onCommentDeletedEvent(CommentDeletedEvent event) {
                if (BaseEditableCommentContainer.this.id != null && event.getId().equals(BaseEditableCommentContainer.this.id)) {
                    BaseEditableCommentContainer.this.container.removeFromParent();
                    BaseEditableCommentContainer.this.eventBus.deregister();
                }
            }
        });
    }

    @Override
    protected void createChildrenPresenter(Integer id, CommentRPCService<T> rpcService, HandlerManager handlerManager, List<CommentGO> replies) {
        new CommentListPresenter(this.displays.replies, rpcService, handlerManager, id, replies);
    }

    @Override
    protected void createReplyPresenter(Integer id, T comment, CommentRPCService<T> rpcService, HandlerManager handlerManager) {
        new CommentEditPresenter<T>(rpcService, handlerManager, this.displays.reply, id, null, comment);
    }

    @Override
    protected void createFormPresenter(Integer parentId, Integer id, T comment, CommentRPCService<T> rpcService, HandlerManager handlerManager, List<CommentGO> replies) {
        new CommentViewPresenter<T>(parentId, id, comment, rpcService, handlerManager, (CommentViewPresenter.Display)this.displays.form, replies.size());
    }

    @Override
    protected void createEditPresenter(Integer parentId, Integer id, T comment, CommentRPCService<T> rpcService, HandlerManager handlerManager) {
        new CommentEditPresenter<T>(rpcService, handlerManager, this.displays.edit, parentId, id, comment);
    }
}

