/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.comments.client.ui;

import com.atlassian.fecru.gwt.comments.client.ui.CommentEditPresenter;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.google.gwt.user.client.Timer;

public class Autosave<T extends CommentModel> {
    private final T comment;
    private final CommentEditPresenter presenter;
    private Timer timer;
    private boolean saveStarted = false;
    private Cancel pendingCancellation;

    public Autosave(T comment, CommentEditPresenter presenter) {
        this.comment = comment;
        this.presenter = presenter;
    }

    public void changed() {
        if (this.timer == null) {
            this.timer = new Timer(){

                public void run() {
                    if (Autosave.this.pendingCancellation == null) {
                        Autosave.this.saveStarted = true;
                        Autosave.this.presenter.autosave(new Runnable(){

                            @Override
                            public void run() {
                                if (Autosave.this.pendingCancellation != null) {
                                    Autosave.this.pendingCancellation.stopped();
                                }
                                Autosave.this.timer = null;
                                Autosave.this.pendingCancellation = null;
                                Autosave.this.saveStarted = false;
                            }
                        });
                    }
                }
            };
            this.timer.schedule(5000);
        }
    }

    public void cancel(Cancel cancel) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.pendingCancellation = cancel;
        if (!this.saveStarted) {
            cancel.stopped();
            this.pendingCancellation = null;
        }
    }

    public static interface Cancel {
        public void stopped();
    }
}

