/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationException;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import java.util.Arrays;
import java.util.List;

public class ValidatorChain<T>
implements Validator<T> {
    private List<Validator<T>> validators;

    public ValidatorChain(Validator<T> ... validators) {
        this.validators = Arrays.asList(validators);
    }

    @Override
    public ValidationMessages validate(T t2, ValidationMessages messages) {
        for (Validator<T> validator : this.validators) {
            validator.validate(t2, messages);
        }
        return messages;
    }

    public static <T> ValidationMessages validate(T validatable, Validator<T> ... validators) {
        return ValidatorChain.validate(validatable, new ValidationMessages(), validators);
    }

    public static <T> ValidationMessages validate(T validatable, ValidationMessages messages, Validator<T> ... validators) {
        return new ValidatorChain<T>(validators).validate(validatable, messages);
    }

    public static <T> void validateAndThrowIfNotEmpty(T validatable, Validator<T> ... validators) throws ValidationException {
        ValidatorChain.validateAndThrowIfNotEmpty(validatable, new ValidationMessages(), validators);
    }

    public static <T> void validateAndThrowIfNotEmpty(T validatable, ValidationMessages messages, Validator<T> ... validators) throws ValidationException {
        Validator.Utils.throwIfNotEmpty(ValidatorChain.validate(validatable, messages, validators));
    }
}

