/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationException;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;

public interface Validator<T> {
    public ValidationMessages validate(T var1, ValidationMessages var2);

    public static class Utils {
        public static <U> void validateAndThrowIfNonEmpty(U validatable, Validator<U> validator) throws ValidationException {
            Utils.throwIfNotEmpty(validator.validate(validatable, new ValidationMessages()));
        }

        public static void throwIfNotEmpty(ValidationMessages messages) throws ValidationException {
            if (messages.size() > 0) {
                throw new ValidationException(messages);
            }
        }

        public static ValidationMessages ensureNotEmptyOrNull(String value, String validationId, String message, ValidationMessages messages) {
            return Utils.ensure(!Utils.isEmptyOrNull(value), validationId, message, messages);
        }

        public static ValidationMessages ensure(boolean test, String validationId, String message, ValidationMessages messages) {
            if (!test) {
                messages.addMessage(new ValidationMessage(validationId, message));
            }
            return messages;
        }

        public static boolean isEmptyOrNull(String value) {
            return value == null || "".equals(value.trim());
        }
    }
}

