/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ValidationMessages
implements IsSerializable,
Iterable<ValidationMessage> {
    private Map<String, List<ValidationMessage>> targetIdToMessages;
    private List<ValidationMessage> messages = new LinkedList<ValidationMessage>();

    public ValidationMessages() {
        this.targetIdToMessages = new HashMap<String, List<ValidationMessage>>();
    }

    public ValidationMessages(ValidationMessage ... messages) {
        this(Arrays.asList(messages));
    }

    public ValidationMessages(List<ValidationMessage> messages) {
        this();
        this.setMessages(messages);
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public void addMessage(ValidationMessage message) {
        this.messages.add(message);
        List<ValidationMessage> perTargetIdMessages = this.targetIdToMessages.get(message.getTargetId());
        if (perTargetIdMessages == null) {
            perTargetIdMessages = new LinkedList<ValidationMessage>();
            this.targetIdToMessages.put(message.getTargetId(), perTargetIdMessages);
        }
        perTargetIdMessages.add(message);
    }

    public void setMessages(List<ValidationMessage> messages) {
        this.messages.clear();
        this.targetIdToMessages.clear();
        for (ValidationMessage message : messages) {
            this.addMessage(message);
        }
    }

    public int size() {
        return this.messages.size();
    }

    @Override
    public Iterator<ValidationMessage> iterator() {
        return this.messages.iterator();
    }

    public List<ValidationMessage> getFor(String targetId) {
        return this.targetIdToMessages.get(targetId);
    }

    public String toString() {
        return this.messages.toString();
    }
}

