/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;

public class SvnRepositoryClientValidator
implements Validator<RepositoryDetails> {
    private final FieldValidationConstants validationConstants;

    public SvnRepositoryClientValidator(FieldValidationConstants validationConstants) {
        this.validationConstants = validationConstants;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails update, ValidationMessages messages) {
        if (update instanceof SvnRepositoryDetails) {
            SvnRepositoryDetails svnUpdate = (SvnRepositoryDetails)update;
            Validator.Utils.ensureNotEmptyOrNull(svnUpdate.getUrl(), "svn.url", "You must specify a SVN URL", messages);
            if (svnUpdate.getAdvancedOptions() != null) {
                if (svnUpdate.getAdvancedOptions().getBlockSize() != null) {
                    Validator.Utils.ensure(svnUpdate.getAdvancedOptions().getBlockSize() > 0, "svn.blocksize", this.validationConstants.blockSizeMustBePostitive(), messages);
                }
                if (svnUpdate.getAdvancedOptions().getThrottle() != null) {
                    Validator.Utils.ensure(svnUpdate.getAdvancedOptions().getThrottle().floatValue() > 0.0f, "svn.throttle", this.validationConstants.connectionsPerSecMustBePositive(), messages);
                }
                if (svnUpdate.getAdvancedOptions().getStartRevision() != null) {
                    Validator.Utils.ensure(svnUpdate.getAdvancedOptions().getStartRevision() >= 0L, "svn.startrevision", this.validationConstants.startRevMustBeNonNegative(), messages);
                }
            }
        }
        return messages;
    }
}

