/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.gwt.core.util.GwtStringUtil;

public class RepositoryClientValidator
implements Validator<RepositoryDetails> {
    private static final String NAME_REGEX = "^[a-zA-Z0-9\\-_\\.]+$";
    private final FieldValidationConstants validationConstants;

    public RepositoryClientValidator(FieldValidationConstants validationConstants) {
        this.validationConstants = validationConstants;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails update, ValidationMessages messages) {
        String name = GwtStringUtil.trim(update.getName());
        if (name == null) {
            messages.addMessage(new ValidationMessage("name", this.validationConstants.nameNeeded()));
        } else if (!name.matches(NAME_REGEX)) {
            messages.addMessage(new ValidationMessage("name", this.validationConstants.nameNotValid()));
        } else if (name.startsWith(".")) {
            messages.addMessage(new ValidationMessage("name", this.validationConstants.nameInvalidPrefix()));
        }
        return messages;
    }
}

