/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.repositories.PerforceRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;

public class PerforceRepositoryClientValidator
implements Validator<RepositoryDetails> {
    private final FieldValidationConstants validationConstants;

    public PerforceRepositoryClientValidator(FieldValidationConstants validationConstants) {
        this.validationConstants = validationConstants;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails update, ValidationMessages messages) {
        if (update instanceof PerforceRepositoryDetails) {
            PerforceRepositoryDetails perforceUpdate = (PerforceRepositoryDetails)update;
            Validator.Utils.ensureNotEmptyOrNull(perforceUpdate.getHost(), "perforce.host", this.validationConstants.hostNeeded(), messages);
            Validator.Utils.ensureNotEmptyOrNull(perforceUpdate.getPath(), "perforce.path", this.validationConstants.perforcePathNeeded(), messages);
            if (perforceUpdate.getPort() != null) {
                Validator.Utils.ensure(perforceUpdate.getPort() >= 0, "perforce.port", this.validationConstants.portMustBePositive(), messages);
            }
            if (perforceUpdate.getAdvancedOptions() != null) {
                if (perforceUpdate.getAdvancedOptions().getBlockSize() != null) {
                    Validator.Utils.ensure(perforceUpdate.getAdvancedOptions().getBlockSize() > 0, "perforce.blocksize", this.validationConstants.blockSizeMustBePostitive(), messages);
                }
                if (perforceUpdate.getAdvancedOptions().getFilelogLimit() != null) {
                    Validator.Utils.ensure(perforceUpdate.getAdvancedOptions().getFilelogLimit() > 0, "perforce.fileloglimit", this.validationConstants.perforceFileLogLimitMustBePositive(), messages);
                }
                if (perforceUpdate.getAdvancedOptions().getThrottle() != null) {
                    Validator.Utils.ensure(perforceUpdate.getAdvancedOptions().getThrottle().floatValue() > 0.0f, "perforce.throttle", this.validationConstants.connectionsPerSecMustBePositive(), messages);
                }
                if (perforceUpdate.getAdvancedOptions().getStartRevision() != null) {
                    Validator.Utils.ensure(perforceUpdate.getAdvancedOptions().getStartRevision() >= 0L, "perforce.startrevision", this.validationConstants.startRevMustBeNonNegative(), messages);
                }
            }
        }
        return messages;
    }
}

