/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle;
import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.MercurialRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.AuthenticationOptionsClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;

public class MercurialRepositoryClientValidator
implements Validator<RepositoryDetails> {
    private final FieldValidationConstants validationConstants;

    public MercurialRepositoryClientValidator(FieldValidationConstants validationConstants) {
        this.validationConstants = validationConstants;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails details, ValidationMessages messages) {
        if (details instanceof MercurialRepositoryDetails) {
            AuthenticationOptions authOpts;
            MercurialRepositoryDetails mercurialDetails = (MercurialRepositoryDetails)details;
            String location = mercurialDetails.getRepoLocation();
            Validator.Utils.ensureNotEmptyOrNull(location, "mercurial.repolocation", this.validationConstants.mercurialRepoLocationNeeded(), messages);
            if (mercurialDetails.getAdvancedOptions() != null && mercurialDetails.getAdvancedOptions().getBlockSize() != null) {
                Validator.Utils.ensure(mercurialDetails.getAdvancedOptions().getBlockSize() > 0, "mercurial.blocksize", this.validationConstants.blockSizeMustBePostitive(), messages);
            }
            if ((authOpts = mercurialDetails.getAuthenticationOptions()) != null) {
                messages = new AuthenticationOptionsClientValidator(this.validationConstants, mercurialDetails.getRepoLocation(), "mercurial.repolocation").validate(authOpts, messages);
                if (location != null) {
                    boolean isSsh = AuthenticationStyle.GEN_SSH_KEY_PAIR.equals((Object)authOpts.getStyle()) || AuthenticationStyle.UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE.equals((Object)authOpts.getStyle());
                    boolean isSshUrl = location.startsWith("ssh://");
                    Validator.Utils.ensure(!isSsh || isSshUrl, "mercurial.repolocation", this.validationConstants.authMustUseSshUrlWithSshKey(), messages);
                }
            }
        }
        return messages;
    }
}

