/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle;
import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.GitRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.AuthenticationOptionsClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;

public class GitRepositoryClientValidator
implements Validator<RepositoryDetails> {
    private final FieldValidationConstants validationConstants;

    public GitRepositoryClientValidator(FieldValidationConstants validationConstants) {
        this.validationConstants = validationConstants;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails details, ValidationMessages messages) {
        if (details instanceof GitRepositoryDetails) {
            AuthenticationOptions authOpts;
            GitRepositoryDetails gitDetails = (GitRepositoryDetails)details;
            Validator.Utils.ensureNotEmptyOrNull(gitDetails.getRepoLocation(), "git.repolocation", this.validationConstants.gitRepoLocationNeeded(), messages);
            if (gitDetails.getAdvancedOptions() != null && gitDetails.getAdvancedOptions().getBlockSize() != null) {
                Validator.Utils.ensure(gitDetails.getAdvancedOptions().getBlockSize() > 0, "git.blocksize", this.validationConstants.blockSizeMustBePostitive(), messages);
            }
            if ((authOpts = gitDetails.getAuthenticationOptions()) != null) {
                messages = new AuthenticationOptionsClientValidator(this.validationConstants, gitDetails.getRepoLocation(), "git.repolocation").validate(gitDetails.getAuthenticationOptions(), messages);
                String url = gitDetails.getRepoLocation();
                this.validateNoAuthenticationForGitProtocol(messages, authOpts, url);
            }
        }
        return messages;
    }

    private void validateNoAuthenticationForGitProtocol(ValidationMessages messages, AuthenticationOptions authOpts, String location) {
        if (location != null) {
            boolean isGitProtocolUrl = location.startsWith("git://");
            boolean anyAuthentication = authOpts.getStyle() != AuthenticationStyle.NO_AUTH;
            Validator.Utils.ensure(!isGitProtocolUrl || !anyAuthentication, "git.repolocation", "The 'git' protocol does not allow authentication", messages);
        }
    }
}

