/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle;
import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.gwt.core.util.GwtStringUtil;

public class AuthenticationOptionsClientValidator
implements Validator<AuthenticationOptions> {
    private final FieldValidationConstants validationConstants;
    private final String url;
    private final String validationId;

    public AuthenticationOptionsClientValidator(FieldValidationConstants validationConstants, String url, String validationId) {
        this.validationConstants = validationConstants;
        this.url = url;
        this.validationId = validationId;
    }

    @Override
    public ValidationMessages validate(AuthenticationOptions authOpts, ValidationMessages messages) {
        if (authOpts != null) {
            if (this.url != null) {
                this.validateNoInconsistentPasswordsProvided(authOpts, messages);
                this.validateLocationForSshAuthentication(authOpts, messages);
                this.validateLocationForNonPasswordAuthentication(authOpts, messages);
            }
            this.validateRequiredFieldsAreProvided(authOpts, messages);
        }
        return messages;
    }

    private void validateRequiredFieldsAreProvided(AuthenticationOptions authOpts, ValidationMessages messages) {
        switch (authOpts.getStyle()) {
            case PASSWORD: {
                Validator.Utils.ensure(!this.isEmpty(authOpts.getPassword()) || !authOpts.getShouldUpdatePassword(), "auth.password", "You must enter a password", messages);
                break;
            }
            case GEN_SSH_KEY_PAIR: {
                Validator.Utils.ensure(!this.isEmpty(authOpts.getPublicKey()), "auth.ssh", "You must generate a key pair", messages);
                break;
            }
            case UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE: {
                Validator.Utils.ensure(!this.isEmpty(authOpts.getKeyName()), "auth.ssh", "You must upload a private key", messages);
            }
        }
    }

    private void validateLocationForNonPasswordAuthentication(AuthenticationOptions authOpts, ValidationMessages messages) {
        boolean isPassword = AuthenticationStyle.PASSWORD.equals((Object)authOpts.getStyle());
        boolean isSshUrl = this.url.startsWith("ssh://");
        Validator.Utils.ensure(!isPassword || !isSshUrl, this.validationId, this.validationConstants.authMustNotUsePasswordWithSshUrl(), messages);
    }

    private void validateLocationForSshAuthentication(AuthenticationOptions authOpts, ValidationMessages messages) {
        boolean isSSH = AuthenticationStyle.GEN_SSH_KEY_PAIR.equals((Object)authOpts.getStyle()) || AuthenticationStyle.UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE.equals((Object)authOpts.getStyle());
        boolean isHttpUrl = this.url.startsWith("http://") || this.url.startsWith("https://");
        Validator.Utils.ensure(!isSSH || !isHttpUrl, this.validationId, this.validationConstants.authMustNotUseHttpWithSshKey(), messages);
    }

    private void validateNoInconsistentPasswordsProvided(AuthenticationOptions authOpts, ValidationMessages messages) {
        String password;
        String passwordMatcherPattern = "(\\w{2,6}://)([^@\\s:]+)(:[^@\\s:]+)(@[^\\s]+)";
        if (this.url.matches("(\\w{2,6}://)([^@\\s:]+)(:[^@\\s:]+)(@[^\\s]+)") && !GwtStringUtil.nullOrEmpty(password = this.url.replaceFirst("(\\w{2,6}://)([^@\\s:]+)(:[^@\\s:]+)(@[^\\s]+)", "$3").substring(1))) {
            if (AuthenticationStyle.PASSWORD.equals((Object)authOpts.getStyle())) {
                Validator.Utils.ensure(password.equals(authOpts.getPassword()), this.validationId, this.validationConstants.authMustNotHaveConflictingPasswords(), messages);
            } else if (AuthenticationStyle.GEN_SSH_KEY_PAIR.equals((Object)authOpts.getStyle()) || AuthenticationStyle.UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE.equals((Object)authOpts.getStyle())) {
                messages.addMessage(new ValidationMessage(this.validationId, this.validationConstants.authMustNotUsePasswordWithSshKey()));
            }
        }
    }

    private boolean isEmpty(String str) {
        return GwtStringUtil.nullOrEmpty(str);
    }
}

