/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories;

import com.atlassian.fecru.gwt.admin.shared.repositories.AllowProcessSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.CommitMessageSyntaxSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.GroupPermission;
import com.atlassian.fecru.gwt.admin.shared.repositories.GroupPermissionsSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.HiddenDirsSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.LinkersSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.TarballSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.UpdateOptions;
import com.google.gwt.user.client.rpc.IsSerializable;

public class RepositoryOptions
implements IsSerializable {
    private LinkersSettings linkersSettings;
    private boolean allowAnonymousAccess;
    private boolean allowLoggedUsersAccess;
    private GroupPermissionsSettings groupPermissionsSettings;
    private AllowProcessSettings allowProcessSettings;
    private HiddenDirsSettings hiddenDirsSettings;
    private TarballSettings tarballsSettings;
    private CommitMessageSyntaxSettings commitMessageSyntaxSettings;
    private Boolean allowChangesetDiscussion;
    private Boolean watchersEnabled;
    private Long maxIndexableSize;
    private UpdateOptions updateOptions;
    private Boolean showCheckoutURLs;

    protected RepositoryOptions() {
    }

    public RepositoryOptions(LinkersSettings linkersSettings, boolean allowAnonymousAccess, boolean allowLoggedUsersAccess, GroupPermissionsSettings groupPermissionsSettings, AllowProcessSettings allowProcessSettings, HiddenDirsSettings hiddenDirsSettings, TarballSettings tarballsSettings, UpdateOptions updateOptions, CommitMessageSyntaxSettings commitMessageSyntaxSettings, Boolean allowChangesetDiscussion, Boolean watchersEnabled, Long maxIndexableSize, Boolean showCheckoutURLs) {
        this.linkersSettings = linkersSettings;
        this.allowAnonymousAccess = allowAnonymousAccess;
        this.allowLoggedUsersAccess = allowLoggedUsersAccess;
        this.showCheckoutURLs = showCheckoutURLs;
        this.groupPermissionsSettings = this.validate(groupPermissionsSettings, allowAnonymousAccess);
        this.allowProcessSettings = allowProcessSettings;
        this.hiddenDirsSettings = hiddenDirsSettings;
        this.tarballsSettings = tarballsSettings;
        this.commitMessageSyntaxSettings = commitMessageSyntaxSettings;
        this.allowChangesetDiscussion = allowChangesetDiscussion;
        this.watchersEnabled = watchersEnabled;
        this.maxIndexableSize = maxIndexableSize;
        this.updateOptions = updateOptions;
    }

    private GroupPermissionsSettings validate(GroupPermissionsSettings groupPermissions, Boolean allowAnonymousAccess) {
        if (allowAnonymousAccess != null && allowAnonymousAccess.booleanValue()) {
            for (GroupPermission permission : groupPermissions.getGroups()) {
                permission.setAllowRead(false);
            }
        }
        return groupPermissions;
    }

    public Long getMaxIndexableSize() {
        return this.maxIndexableSize;
    }

    public LinkersSettings getLinkersSettings() {
        return this.linkersSettings;
    }

    public Boolean isWatchersEnabled() {
        return this.watchersEnabled;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public boolean isAllowLoggedUsersAccess() {
        return this.allowLoggedUsersAccess;
    }

    public GroupPermissionsSettings getGroupPermissions() {
        return this.groupPermissionsSettings;
    }

    public AllowProcessSettings getAllowProcessSettings() {
        return this.allowProcessSettings;
    }

    public HiddenDirsSettings getHiddenDirsSettings() {
        return this.hiddenDirsSettings;
    }

    public TarballSettings getTarballsSettings() {
        return this.tarballsSettings;
    }

    public CommitMessageSyntaxSettings getCommitMessageSyntaxSettings() {
        return this.commitMessageSyntaxSettings;
    }

    public Boolean isAllowChangesetDiscussion() {
        return this.allowChangesetDiscussion;
    }

    public UpdateOptions getUpdateOptions() {
        return this.updateOptions;
    }

    public Boolean getShowCheckoutURLs() {
        return this.showCheckoutURLs;
    }
}

